/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.warp.manager;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import me.testaccount666.serversystem.commands.executables.warp.manager.Warp;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;

public class WarpManager {
    private final Set<Warp> _warps = new HashSet<Warp>();
    private final FileConfiguration _config;
    private final File _file;

    public WarpManager(FileConfiguration config, File file) {
        this._config = config;
        this._file = file;
        this.loadWarps();
    }

    public Set<Warp> getWarps() {
        return Collections.unmodifiableSet(this._warps);
    }

    public Warp addWarp(String name, Location location) {
        return this.addWarp(name, location, true);
    }

    public Warp addWarp(String name, Location location, boolean saveWarps) {
        return this.addWarp(new Warp(name, location), saveWarps);
    }

    public void addWarp(Warp warp) {
        this.addWarp(warp, true);
    }

    public Warp addWarp(Warp warp, boolean saveWarps) {
        this._warps.add(warp);
        if (saveWarps) {
            this.saveWarps();
        }
        return warp;
    }

    public void removeWarp(String name) {
        this._warps.removeIf(warp -> warp.getName().equalsIgnoreCase(name));
        this.saveWarps();
    }

    public void removeWarp(Warp warp) {
        this._warps.removeIf(savedWarp -> savedWarp.getName().equalsIgnoreCase(warp.getName()));
        this.saveWarps();
    }

    public Optional<Warp> getWarpByName(String name) {
        return this._warps.stream().filter(warp -> warp.getName().equalsIgnoreCase(name)).findFirst();
    }

    public boolean warpExists(String name) {
        return this.getWarpByName(name).isPresent();
    }

    private void saveWarps() {
        this._config.set("Warps", null);
        for (Warp warp : this._warps) {
            String prefix = "Warps." + warp.getName();
            this._config.set(prefix + ".X", (Object)warp.getLocation().getX());
            this._config.set(prefix + ".Y", (Object)warp.getLocation().getY());
            this._config.set(prefix + ".Z", (Object)warp.getLocation().getZ());
            this._config.set(prefix + ".Yaw", (Object)Float.valueOf(warp.getLocation().getYaw()));
            this._config.set(prefix + ".Pitch", (Object)Float.valueOf(warp.getLocation().getPitch()));
            this._config.set(prefix + ".World", (Object)warp.getLocation().getWorld().getName());
        }
        try {
            this._config.save(this._file);
        }
        catch (IOException exception) {
            throw new RuntimeException("Error saving warps file", exception);
        }
    }

    private void loadWarps() {
        this._warps.clear();
        if (!this._config.isConfigurationSection("Warps")) {
            return;
        }
        Set warpNames = this._config.getConfigurationSection("Warps").getKeys(false);
        for (String name : warpNames) {
            String prefix;
            Optional<Warp> warp = this.parseWarp(name, prefix = "Warps." + name);
            if (warp.isEmpty()) continue;
            this._warps.add(warp.get());
        }
    }

    private Optional<Warp> parseWarp(String name, String prefix) {
        double x = this._config.getDouble(prefix + ".X");
        double y = this._config.getDouble(prefix + ".Y");
        double z = this._config.getDouble(prefix + ".Z");
        float yaw = (float)this._config.getDouble(prefix + ".Yaw");
        float pitch = (float)this._config.getDouble(prefix + ".Pitch");
        String worldName = this._config.getString(prefix + ".World", "");
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return Optional.empty();
        }
        Location location = new Location(world, x, y, z, yaw, pitch);
        return Optional.of(new Warp(name, location));
    }
}

