/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.listener.executables.operatorspoof;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.annotations.RequiredCommands;
import me.testaccount666.serversystem.commands.executables.gamemode.CommandGameMode;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemCommandExecutor;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.UserManager;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ServerboundChangeGameModePacket;
import net.minecraft.world.level.GameType;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;

@RequiredCommands(requiredCommands={CommandGameMode.class})
public class ListenerOperatorSpoof
implements Listener {
    private boolean _caughtException = false;
    private boolean _injectionPossible = true;
    private CommandGameMode _executorGameMode;

    public ListenerOperatorSpoof() {
        Bukkit.getOnlinePlayers().forEach(this::inject);
    }

    public boolean canRegister(Set<ServerSystemCommandExecutor> requiredCommands) {
        AtomicBoolean canRegister = new AtomicBoolean(false);
        requiredCommands.forEach(command -> {
            if (!(command instanceof CommandGameMode)) {
                return;
            }
            CommandGameMode commandGameMode = (CommandGameMode)command;
            this._executorGameMode = commandGameMode;
            canRegister.set(true);
        });
        return canRegister.get();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.updateFakeOperatorStatus(event.getPlayer());
        this.inject(event.getPlayer());
    }

    @EventHandler
    public void onPlayerWorldChange(PlayerChangedWorldEvent event) {
        this.updateFakeOperatorStatus(event.getPlayer());
    }

    @EventHandler
    public void onGameModeChange(PlayerGameModeChangeEvent event) {
        this.updateFakeOperatorStatus(event.getPlayer());
    }

    private void updateFakeOperatorStatus(Player player) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        CraftServer craftServer = (CraftServer)Bukkit.getServer();
        craftServer.getHandle().sendPlayerPermissionLevel(craftPlayer.getHandle(), 28, false);
    }

    private void inject(Player player) {
        if (!this._injectionPossible) {
            return;
        }
        try {
            Class.forName("net.minecraft.network.protocol.game.ServerboundChangeGameModePacket");
        }
        catch (Throwable ignored) {
            this._injectionPossible = false;
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)player;
        Connection playerConnection = craftPlayer.getHandle().connection.connection;
        ChannelPipeline pipeline = playerConnection.channel.pipeline();
        if (pipeline.get("gamemode_packet_listener") != null) {
            pipeline.remove("gamemode_packet_listener");
        }
        pipeline.addBefore("packet_handler", "gamemode_packet_listener", (ChannelHandler)new GameModePacketListener(player));
    }

    private void uninject(Player player) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        Connection playerConnection = craftPlayer.getHandle().connection.connection;
        ChannelPipeline pipeline = playerConnection.channel.pipeline();
        if (pipeline.get("gamemode_packet_listener") == null) {
            return;
        }
        pipeline.remove("gamemode_packet_listener");
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.uninject(event.getPlayer());
    }

    @EventHandler
    public void onPluginUnload(PluginDisableEvent event) {
        if (event.getPlugin() != ServerSystem.Instance) {
            return;
        }
        Bukkit.getOnlinePlayers().forEach(this::uninject);
    }

    private class GameModePacketListener
    extends ChannelDuplexHandler {
        private final Player _player;
        private final CachedUser _cachedUser;

        public GameModePacketListener(Player player) {
            this._player = player;
            Optional<CachedUser> cachedUserOptional = ServerSystem.Instance.getRegistry().getService(UserManager.class).getUser(player);
            if (cachedUserOptional.isEmpty()) {
                throw new RuntimeException("Couldn't cache User '" + player.getName() + "'! This should not happen!");
            }
            this._cachedUser = cachedUserOptional.get();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                if (this._cachedUser.isOfflineUser()) {
                    super.channelRead(ctx, msg);
                    return;
                }
                if (!(msg instanceof ServerboundChangeGameModePacket)) {
                    super.channelRead(ctx, msg);
                    return;
                }
                ServerboundChangeGameModePacket serverboundChangeGameModePacket = (ServerboundChangeGameModePacket)msg;
                try {
                    GameType gameType;
                    GameType mode = gameType = serverboundChangeGameModePacket.mode();
                }
                catch (Throwable mode332) {
                    throw new MatchException(mode332.toString(), mode332);
                }
                if (this._player.isOp()) {
                    super.channelRead(ctx, msg);
                    return;
                }
                GameMode gameMode = GameMode.valueOf((String)mode332.getName().toUpperCase());
                User user = (User)this._cachedUser.getOfflineUser();
                Bukkit.getScheduler().runTask((Plugin)ServerSystem.Instance, () -> ListenerOperatorSpoof.this._executorGameMode.handleGameModeCommand(user, null, "gamemode", gameMode, new String[0]));
                return;
            }
            catch (Throwable throwable) {
                if (!ListenerOperatorSpoof.this._caughtException) {
                    ServerSystem.getLog().log(Level.WARNING, "Caught exception in channel pipeline, report this to the developer of ServerSystem!\nThis will only display once", throwable);
                    ListenerOperatorSpoof.this._caughtException = true;
                }
                super.channelRead(ctx, msg);
            }
        }
    }
}

