/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.managers;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.managers.config.ConfigReader;
import me.testaccount666.serversystem.managers.config.DefaultConfigReader;
import me.testaccount666.serversystem.userdata.User;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class PermissionManager {
    private static final File _PERMISSION_FILE = Path.of("plugins", "ServerSystem", "permissions.yml").toFile();
    private static ConfigReader _ConfigReader;

    public static void initialize(Plugin plugin) throws FileNotFoundException {
        _ConfigReader = new DefaultConfigReader(_PERMISSION_FILE, plugin);
    }

    public static boolean hasCommandPermission(CommandSender commandSender, String permissionPath, boolean sendFailInfo) {
        return PermissionManager.hasPermission(commandSender, "Commands." + permissionPath, sendFailInfo);
    }

    public static boolean hasCommandPermission(User user, String permissionPath, boolean sendFailInfo) {
        return PermissionManager.hasPermission(user.getCommandSender(), "Commands." + permissionPath, sendFailInfo);
    }

    public static boolean hasCommandPermission(CommandSender commandSender, String permissionPath) {
        return PermissionManager.hasPermission(commandSender, "Commands." + permissionPath);
    }

    public static boolean hasCommandPermission(User commandSender, String permissionPath) {
        return PermissionManager.hasCommandPermission(commandSender.getCommandSender(), permissionPath);
    }

    public static boolean hasPermission(CommandSender commandSender, String permissionPath) {
        return PermissionManager.hasPermission(commandSender, permissionPath, true);
    }

    public static boolean hasPermission(User commandSender, String permissionPath, boolean sendFailInfo) {
        return PermissionManager.hasPermission(commandSender.getCommandSender(), permissionPath, sendFailInfo);
    }

    public static boolean hasPermission(CommandSender commandSender, String permissionPath, boolean sendFailInfo) {
        if (!PermissionManager.isPermissionRequired(permissionPath)) {
            return true;
        }
        String permission = PermissionManager.getPermission(permissionPath);
        return PermissionManager.hasPermissionString(commandSender, permission, sendFailInfo);
    }

    public static boolean hasPermissionString(CommandSender commandSender, String permission) {
        return PermissionManager.hasPermissionString(commandSender, permission, true);
    }

    public static boolean hasPermissionString(CommandSender commandSender, String permission, boolean sendFailInfo) {
        if (permission == null) {
            return false;
        }
        boolean hasPermission = commandSender.hasPermission(permission);
        if (!hasPermission && sendFailInfo) {
            ServerSystem.getLog().info(commandSender.getName() + " has failed a permission check! Permission: " + permission);
        }
        return hasPermission;
    }

    private static boolean isPermissionRequired(String permissionPath) {
        if (_ConfigReader == null) {
            throw new IllegalStateException("PermissionManager was not yet initialized. Call initialize first.");
        }
        permissionPath = "Permissions." + (String)permissionPath + ".Required";
        return _ConfigReader.getBoolean((String)permissionPath, true);
    }

    public static String getPermission(String permissionPath) {
        if (_ConfigReader == null) {
            throw new IllegalStateException("PermissionManager was not yet initialized. Call initialize first.");
        }
        String permission = _ConfigReader.getString((String)(permissionPath = "Permissions." + (String)permissionPath + ".Value"), null);
        if (permission == null) {
            ServerSystem.getLog().warning("Permission '" + (String)permissionPath + "' not found! (Denying permission)");
        }
        return permission;
    }
}

