/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.managers.database;

import com.zaxxer.hikari.HikariConfig;
import java.io.File;
import me.testaccount666.serversystem.managers.config.ConfigReader;

public class HikariConfigUtil {
    public static HikariConfig configureMySql(ConfigReader configReader, String configPrefix, String poolName) {
        String host = configReader.getString(configPrefix + ".Host");
        int port = configReader.getInt(configPrefix + ".Port");
        String database = configReader.getString(configPrefix + ".Database");
        String username = configReader.getString(configPrefix + ".Username");
        String password = configReader.getString(configPrefix + ".Password");
        boolean useSSL = configReader.getBoolean(configPrefix + ".UseSSL");
        int maxPoolSize = configReader.getInt(configPrefix + ".Pool.MaxSize", 10);
        int minIdle = configReader.getInt(configPrefix + ".Pool.MinIdle", 5);
        long maxLifetime = configReader.getLong(configPrefix + ".Pool.MaxLifetime", 30L) * 60000L;
        long connectionTimeout = configReader.getLong(configPrefix + ".Pool.ConnectionTimeout", 30L) * 1000L;
        long idleTimeout = configReader.getLong(configPrefix + ".Pool.IdleTimeout", 600L) * 1000L;
        String jdbcUrl = "jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=" + useSSL + "&autoReconnect=true";
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(jdbcUrl);
        config.setUsername(username);
        config.setPassword(password);
        config.setPoolName(poolName);
        config.setMaximumPoolSize(maxPoolSize);
        config.setMinimumIdle(minIdle);
        config.setMaxLifetime(maxLifetime);
        config.setConnectionTimeout(connectionTimeout);
        config.setIdleTimeout(idleTimeout);
        config.setConnectionTestQuery("SELECT 1");
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        config.addDataSourceProperty("useServerPrepStmts", (Object)"true");
        config.addDataSourceProperty("rewriteBatchedStatements", (Object)"true");
        return config;
    }

    public static HikariConfig configureSqlite(File databaseFile, String poolName) {
        String jdbcUrl = "jdbc:sqlite:" + databaseFile.getAbsolutePath();
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(jdbcUrl);
        config.setPoolName(poolName);
        config.setMaximumPoolSize(1);
        config.setConnectionTimeout(30000L);
        config.setIdleTimeout(600000L);
        config.setMinimumIdle(1);
        config.setConnectionTestQuery("SELECT 1");
        config.addDataSourceProperty("foreign_keys", (Object)"true");
        config.addDataSourceProperty("journal_mode", (Object)"WAL");
        config.addDataSourceProperty("busy_timeout", (Object)"5000");
        config.addDataSourceProperty("synchronous", (Object)"NORMAL");
        return config;
    }
}

