/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.managers.database.economy;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.managers.config.ConfigReader;
import me.testaccount666.serversystem.managers.database.HikariConfigUtil;
import me.testaccount666.serversystem.managers.database.economy.AbstractEconomyDatabaseManager;

public class MySqlEconomyDatabaseManager
extends AbstractEconomyDatabaseManager {
    public MySqlEconomyDatabaseManager(ConfigReader configReader) {
        super(configReader);
    }

    @Override
    protected void initializeConnection() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            return;
        }
        HikariConfig config = HikariConfigUtil.configureMySql(this.configReader, "Economy.MySQL", "economy-hikari-pool");
        this.dataSource = new HikariDataSource(config);
        ServerSystem.getLog().info("Successfully initialized MySQL connection pool for economy.");
    }

    @Override
    protected void createTablesIfNotExist() throws SQLException {
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("    CREATE TABLE IF NOT EXISTS Economy (\n        Owner VARCHAR(36) NOT NULL,\n        Balance DECIMAL(65,2) NOT NULL,\n        AccountId VARCHAR(36) NOT NULL,\n        PRIMARY KEY (Owner, AccountId)\n    )\n");
            statement.execute("CREATE INDEX IF NOT EXISTS idx_owner ON Economy (Owner)");
            statement.execute("CREATE INDEX IF NOT EXISTS idx_account_id ON Economy (AccountId)");
        }
    }
}

