/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.managers.database.moderation;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.managers.database.HikariConfigUtil;
import me.testaccount666.serversystem.managers.database.moderation.AbstractModerationDatabaseManager;

public class SqliteModerationDatabaseManager
extends AbstractModerationDatabaseManager {
    private final File _databaseFile;

    public SqliteModerationDatabaseManager(File dataFolder) {
        super(null);
        this._databaseFile = Path.of(dataFolder.getPath(), "data", "moderation.db").toFile();
    }

    @Override
    public void initialize() {
        try {
            if (!this._databaseFile.getParentFile().exists()) {
                this._databaseFile.getParentFile().mkdirs();
            }
            super.initialize();
        }
        catch (Exception exception) {
            ServerSystem.getLog().log(Level.SEVERE, "Failed to initialize SQLite moderation database", exception);
        }
    }

    @Override
    protected void initializeConnection() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            return;
        }
        HikariConfig config = HikariConfigUtil.configureSqlite(this._databaseFile, "moderation-sqlite-pool");
        this.dataSource = new HikariDataSource(config);
        ServerSystem.getLog().info("Successfully initialized SQLite connection pool for moderation.");
    }

    @Override
    protected void createTablesIfNotExist() throws SQLException {
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("    CREATE TABLE IF NOT EXISTS Moderation (\n        ID INTEGER PRIMARY KEY AUTOINCREMENT,\n        TargetUUID VARCHAR(36) NOT NULL,\n        SenderUUID VARCHAR(36) NOT NULL,\n        IssueTime BIGINT NOT NULL,\n        ExpireTime BIGINT NOT NULL,\n        Reason TEXT NOT NULL,\n        Type VARCHAR(20) NOT NULL\n    )\n");
            statement.execute("CREATE INDEX IF NOT EXISTS idx_target ON Moderation (TargetUUID)");
            statement.execute("CREATE INDEX IF NOT EXISTS idx_type ON Moderation (Type)");
        }
    }
}

