/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.managers.messages;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.managers.config.ConfigReader;
import me.testaccount666.serversystem.managers.config.DefaultConfigReader;
import org.bukkit.plugin.Plugin;

public class LanguageLoader {
    private final Path _baseDirectory = Path.of("plugins", "ServerSystem", "messages");
    private final Map<String, ConfigReader> _languageMessagesMap = new HashMap<String, ConfigReader>();
    private final Map<String, ConfigReader> _languageMappingsMap = new HashMap<String, ConfigReader>();

    public LanguageLoader() {
        ServerSystem plugin = ServerSystem.Instance;
        this.ensureExists((Plugin)plugin, "english");
        this.ensureExists((Plugin)plugin, "german");
        this.ensureExists((Plugin)plugin, "slovene");
    }

    private void ensureExists(Plugin plugin, String language) {
        File messagesFile;
        Path englishDirectory = this._baseDirectory.resolve(language);
        File mappingsFile = englishDirectory.resolve("mappings.yml").toFile();
        if (!mappingsFile.exists()) {
            plugin.saveResource("messages/" + language + "/mappings.yml", false);
        }
        if (!(messagesFile = englishDirectory.resolve("messages.yml").toFile()).exists()) {
            plugin.saveResource("messages/" + language + "/messages.yml", false);
        }
    }

    public Optional<ConfigReader> getMessageReader(String language) {
        ConfigReader configReader = this._languageMessagesMap.get(language = language.toLowerCase());
        if (configReader != null) {
            return Optional.of(configReader);
        }
        ConfigReader loadedReader = this.loadMessageReader(language);
        if (loadedReader == null) {
            return Optional.empty();
        }
        this._languageMessagesMap.put(language, loadedReader);
        return Optional.of(loadedReader);
    }

    private ConfigReader loadMessageReader(String language) {
        File languageDirectory = this._baseDirectory.resolve(language).toFile();
        if (!languageDirectory.exists() || !languageDirectory.isDirectory()) {
            ServerSystem.getLog().warning("Requested language '" + language + "', but doesn't exist!");
            return null;
        }
        File messageFile = languageDirectory.toPath().resolve("messages.yml").toFile();
        if (!messageFile.exists()) {
            ServerSystem.getLog().warning("Requested message language '" + language + "', but doesn't exist!");
            return null;
        }
        return DefaultConfigReader.loadConfiguration(messageFile);
    }

    public Optional<ConfigReader> getMappingReader(String language) {
        ConfigReader configReader = this._languageMappingsMap.get(language = language.toLowerCase());
        if (configReader != null) {
            return Optional.of(configReader);
        }
        ConfigReader loadedReader = this.loadMappingReader(language);
        if (loadedReader == null) {
            return Optional.empty();
        }
        this._languageMappingsMap.put(language, loadedReader);
        return Optional.of(loadedReader);
    }

    private ConfigReader loadMappingReader(String language) {
        File languageDirectory = this._baseDirectory.resolve(language).toFile();
        if (!languageDirectory.exists() || !languageDirectory.isDirectory()) {
            ServerSystem.getLog().warning("Requested language '" + language + "', but doesn't exist!");
            return null;
        }
        File mappingsFile = languageDirectory.toPath().resolve("mappings.yml").toFile();
        if (!mappingsFile.exists()) {
            ServerSystem.getLog().warning("Requested mapping language '" + language + "', but doesn't exist!");
            return null;
        }
        return DefaultConfigReader.loadConfiguration(mappingsFile);
    }
}

