/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.managers.messages;

import java.io.FileNotFoundException;
import java.util.Optional;
import java.util.logging.Level;
import javax.annotation.Nullable;
import lombok.Generated;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.managers.PlaceholderManager;
import me.testaccount666.serversystem.managers.config.ConfigReader;
import me.testaccount666.serversystem.managers.config.ConfigurationManager;
import me.testaccount666.serversystem.managers.messages.LanguageLoader;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.ChatColor;
import me.testaccount666.serversystem.utils.ComponentColor;
import net.kyori.adventure.text.Component;

public final class MessageManager {
    public static final String FALLBACK_LANGUAGE = "english";
    private static LanguageLoader _LanguageLoader;
    private static PlaceholderManager _PlaceholderManager;
    private static String _DefaultLanguage;

    public static void initialize() throws FileNotFoundException {
        _PlaceholderManager = new PlaceholderManager();
        _LanguageLoader = new LanguageLoader();
        _DefaultLanguage = ServerSystem.Instance.getRegistry().getService(ConfigurationManager.class).getGeneralConfig().getString("Language.DefaultLanguage", FALLBACK_LANGUAGE);
        Optional<ConfigReader> messageOptional = MessageManager.getLanguageLoader().getMessageReader(_DefaultLanguage);
        Optional<ConfigReader> mappingsOptional = MessageManager.getLanguageLoader().getMappingReader(_DefaultLanguage);
        if (messageOptional.isPresent() && mappingsOptional.isPresent()) {
            return;
        }
        ServerSystem.getLog().warning("Could not load default language '" + _DefaultLanguage + "'! Falling back to 'english'...");
        ServerSystem.getLog().warning("Make sure you have a 'messages.yml' AND 'mappings.yml' file in your language folder!");
        _DefaultLanguage = FALLBACK_LANGUAGE;
    }

    public static String formatMessage(String message, User commandSender, @Nullable String targetName, @Nullable String label, boolean addPrefix) {
        if (message == null) {
            return "";
        }
        if (addPrefix) {
            String prefix = MessageManager.getMessage(commandSender, "General.Prefix").orElse("");
            message = prefix + (String)message;
        }
        return ChatColor.translateColor(MessageManager.applyPlaceholders((String)message, commandSender, targetName, label));
    }

    public static String applyPlaceholders(String message, User commandSender, @Nullable String targetName, @Nullable String label) {
        return _PlaceholderManager.applyPlaceholders(message, commandSender, targetName, label != null ? label : "");
    }

    public static Component formatMessageAsComponent(String message, User commandSender, @Nullable String targetName, @Nullable String label, boolean addPrefix) {
        if (message == null) {
            return Component.empty();
        }
        if (addPrefix) {
            String prefix = MessageManager.getMessage(commandSender, "General.Prefix").orElse("");
            message = prefix + (String)message;
        }
        String processedMessage = _PlaceholderManager.applyPlaceholders((String)message, commandSender, targetName, label != null ? label : "");
        return ComponentColor.translateToComponent(processedMessage);
    }

    public static Optional<String> getMessage(User user, String messagePath) {
        String language = user != null ? user.getPlayerLanguage() : _DefaultLanguage;
        return MessageManager.getMessage(user, messagePath, language);
    }

    public static Optional<String> getMessage(User user, String messagePath, String language) {
        ConfigReader reader;
        if (_PlaceholderManager == null) {
            throw new IllegalStateException("MessageManager was not yet initialized. Call initialize first.");
        }
        messagePath = "Messages." + (String)messagePath;
        try {
            reader = MessageManager.getConfigReader(language);
        }
        catch (FileNotFoundException exception) {
            ServerSystem.getLog().log(Level.WARNING, "Failed to load messages for language '" + language + "': " + exception.getMessage(), exception);
            reader = MessageManager.getConfigReader(_DefaultLanguage);
        }
        String message = reader.getString((String)messagePath, null);
        if (message == null) {
            ServerSystem.getLog().warning("Message '" + (String)messagePath + "' not found for language " + language + "!");
            return Optional.empty();
        }
        return Optional.of(message);
    }

    private static ConfigReader getConfigReader(String language) throws FileNotFoundException {
        Optional<ConfigReader> readerOptional = _LanguageLoader.getMessageReader(language);
        return readerOptional.orElseGet(() -> _LanguageLoader.getMessageReader(_DefaultLanguage).get());
    }

    @Generated
    private MessageManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static LanguageLoader getLanguageLoader() {
        return _LanguageLoader;
    }

    @Generated
    public static String getDefaultLanguage() {
        return _DefaultLanguage;
    }
}

