/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.placeholderapi.executables;

import java.math.BigDecimal;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.placeholderapi.Placeholder;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.UserManager;
import me.testaccount666.serversystem.userdata.money.AbstractBankAccount;
import me.testaccount666.serversystem.userdata.money.EconomyProvider;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.Nullable;

public class BalancePlaceholder
implements Placeholder {
    @Override
    public String execute(@Nullable OfflineUser user, String identifier, String ... arguments) {
        if (user == null && arguments.length == 0) {
            return "No user specified!";
        }
        if (user == null || arguments.length >= 1) {
            OfflinePlayer player = this.getOfflinePlayer(arguments[0]);
            Optional<OfflineUser> userOptional = this.getOfflineUser(player);
            if (userOptional.isEmpty()) {
                return "User " + arguments[0] + "} not found!";
            }
            user = userOptional.get();
        }
        AbstractBankAccount bankAccount = user.getBankAccount();
        BigDecimal balance = bankAccount.getBalance();
        boolean formatBalance = identifier.equalsIgnoreCase("balance");
        if (!formatBalance) {
            return String.format("%.2f", balance.doubleValue());
        }
        return ServerSystem.Instance.getRegistry().getService(EconomyProvider.class).formatMoney(balance);
    }

    @Override
    public Set<String> getIdentifiers() {
        return Set.of("balance", "unformattedbalance");
    }

    private OfflinePlayer getOfflinePlayer(String nameOrUuid) {
        try {
            UUID uuid = UUID.fromString(nameOrUuid);
            return Bukkit.getOfflinePlayer((UUID)uuid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Bukkit.getOfflinePlayer((String)nameOrUuid);
        }
    }

    private Optional<OfflineUser> getOfflineUser(OfflinePlayer player) {
        Optional<CachedUser> userOptional = ServerSystem.Instance.getRegistry().getService(UserManager.class).getUser(player.getUniqueId());
        if (userOptional.isEmpty()) {
            return Optional.empty();
        }
        CachedUser cachedUser = userOptional.get();
        return Optional.of(cachedUser.getOfflineUser());
    }
}

