/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.updates;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.testaccount666.serversystem.updates.AbstractUpdateChecker;
import me.testaccount666.serversystem.utils.Version;

public class MainUpdateChecker
extends AbstractUpdateChecker {
    public MainUpdateChecker() {
        super(URI.create("https://pluginsupport.zapto.org/PluginSupport/ServerSystem2/"));
    }

    @Override
    protected Version parseLatestVersion(String responseBody) {
        Pattern pattern = Pattern.compile("<a href=\"(\\d+(?:\\.\\d+)*)\">");
        Matcher matcher = pattern.matcher(responseBody);
        Version foundLatestVersion = null;
        while (matcher.find()) {
            String versionString = matcher.group(1);
            Version parsedVersion = new Version(versionString);
            if (foundLatestVersion == null) {
                foundLatestVersion = parsedVersion;
                continue;
            }
            if (parsedVersion.compareTo(foundLatestVersion) <= 0) continue;
            foundLatestVersion = parsedVersion;
        }
        if (foundLatestVersion == null) {
            throw new IllegalStateException("No version found in response body");
        }
        return foundLatestVersion;
    }

    @Override
    protected String getDownloadUrl() {
        return this.updateURI.toString() + this.latestVersion.getVersion();
    }
}

