/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.userdata.home;

import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.Location;

public class Home {
    private static final Pattern _HOME_NAME_PATTERN = Pattern.compile("[A-Za-z0-9_]+");
    private final String _name;
    private final Location _location;
    private String _displayName;

    Home(String name, Location location) {
        if (!_HOME_NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Home name must be alphanumeric");
        }
        this._name = name.toLowerCase();
        this._location = location;
    }

    public static Optional<Home> of(String name, Location location) {
        if (!_HOME_NAME_PATTERN.matcher(name).matches()) {
            return Optional.empty();
        }
        return Optional.of(new Home(name, location));
    }

    public String getDisplayName() {
        if (this._displayName != null) {
            return this._displayName;
        }
        this._displayName = this.getName().toLowerCase();
        char[] chars = this._displayName.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        this._displayName = new String(chars);
        return this._displayName;
    }

    @Generated
    public String getName() {
        return this._name;
    }

    @Generated
    public Location getLocation() {
        return this._location;
    }
}

