/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.userdata.money.vault;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.ServiceRegistry;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.UserManager;
import me.testaccount666.serversystem.userdata.money.AbstractBankAccount;
import me.testaccount666.serversystem.userdata.money.EconomyProvider;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;

public class VaultEconomyProvider
extends AbstractEconomy {
    public boolean isEnabled() {
        return ServerSystem.Instance.isEnabled();
    }

    public String getName() {
        return ServerSystem.Instance.getName();
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return 2;
    }

    public String format(double amount) {
        ServiceRegistry registry = ServerSystem.Instance.getRegistry();
        EconomyProvider economyProvider = registry.getService(EconomyProvider.class);
        return economyProvider.formatMoney(BigDecimal.valueOf(amount));
    }

    public String currencyNamePlural() {
        ServiceRegistry registry = ServerSystem.Instance.getRegistry();
        EconomyProvider economyProvider = registry.getService(EconomyProvider.class);
        return economyProvider.getCurrencyPlural();
    }

    public String currencyNameSingular() {
        ServiceRegistry registry = ServerSystem.Instance.getRegistry();
        EconomyProvider economyProvider = registry.getService(EconomyProvider.class);
        return economyProvider.getCurrencySingular();
    }

    public boolean hasAccount(String name) {
        ServiceRegistry registry = ServerSystem.Instance.getRegistry();
        UserManager userManager = registry.getService(UserManager.class);
        Optional<CachedUser> userOptional = userManager.getUser(name);
        return userOptional.isPresent();
    }

    public boolean hasAccount(String name, String world) {
        return this.hasAccount(name);
    }

    public double getBalance(String name) {
        ServiceRegistry registry = ServerSystem.Instance.getRegistry();
        UserManager userManager = registry.getService(UserManager.class);
        Optional<CachedUser> userOptional = userManager.getUser(name);
        if (userOptional.isEmpty()) {
            return 0.0;
        }
        CachedUser user = userOptional.get();
        OfflineUser offlineUser = user.getOfflineUser();
        AbstractBankAccount bankAccount = offlineUser.getBankAccount();
        return bankAccount.getBalance().doubleValue();
    }

    public double getBalance(String name, String world) {
        return this.getBalance(name);
    }

    public boolean has(String name, double amount) {
        ServiceRegistry registry = ServerSystem.Instance.getRegistry();
        UserManager userManager = registry.getService(UserManager.class);
        Optional<CachedUser> userOptional = userManager.getUser(name);
        if (userOptional.isEmpty()) {
            return false;
        }
        CachedUser user = userOptional.get();
        OfflineUser offlineUser = user.getOfflineUser();
        AbstractBankAccount bankAccount = offlineUser.getBankAccount();
        return bankAccount.hasEnoughMoney(BigDecimal.valueOf(amount));
    }

    public boolean has(String name, String world, double amount) {
        return this.has(name, amount);
    }

    public EconomyResponse withdrawPlayer(String name, double amount) {
        ServiceRegistry registry = ServerSystem.Instance.getRegistry();
        UserManager userManager = registry.getService(UserManager.class);
        Optional<CachedUser> userOptional = userManager.getUser(name);
        if (userOptional.isEmpty()) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "User not found!");
        }
        CachedUser user = userOptional.get();
        OfflineUser offlineUser = user.getOfflineUser();
        AbstractBankAccount bankAccount = offlineUser.getBankAccount();
        bankAccount.withdraw(BigDecimal.valueOf(amount));
        BigDecimal newBalance = bankAccount.getBalance();
        return new EconomyResponse(amount, newBalance.doubleValue(), EconomyResponse.ResponseType.SUCCESS, "Withdraw successful!");
    }

    public EconomyResponse withdrawPlayer(String name, String world, double amount) {
        return this.withdrawPlayer(name, amount);
    }

    public EconomyResponse depositPlayer(String name, double amount) {
        ServiceRegistry registry = ServerSystem.Instance.getRegistry();
        UserManager userManager = registry.getService(UserManager.class);
        Optional<CachedUser> userOptional = userManager.getUser(name);
        if (userOptional.isEmpty()) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "User not found!");
        }
        CachedUser user = userOptional.get();
        OfflineUser offlineUser = user.getOfflineUser();
        AbstractBankAccount bankAccount = offlineUser.getBankAccount();
        bankAccount.deposit(BigDecimal.valueOf(amount));
        BigDecimal newBalance = bankAccount.getBalance();
        return new EconomyResponse(amount, newBalance.doubleValue(), EconomyResponse.ResponseType.SUCCESS, "Deposit successful!");
    }

    public EconomyResponse depositPlayer(String name, String world, double amount) {
        return this.depositPlayer(name, amount);
    }

    public EconomyResponse createBank(String owner, String id) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank creation is not supported!");
    }

    public EconomyResponse deleteBank(String id) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank deletion is not supported!");
    }

    public EconomyResponse bankBalance(String id) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank balance retrieval is not supported!");
    }

    public EconomyResponse bankHas(String id, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank balance retrieval is not supported!");
    }

    public EconomyResponse bankWithdraw(String id, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank withdrawal is not supported!");
    }

    public EconomyResponse bankDeposit(String id, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank deposit is not supported!");
    }

    public EconomyResponse isBankOwner(String id, String owner) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank owner retrieval is not supported!");
    }

    public EconomyResponse isBankMember(String id, String member) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank member retrieval is not supported!");
    }

    public List<String> getBanks() {
        return List.of();
    }

    public boolean createPlayerAccount(String s) {
        return true;
    }

    public boolean createPlayerAccount(String name, String world) {
        return this.createPlayerAccount(name);
    }
}

