/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.userdata.persistence;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import me.testaccount666.serversystem.userdata.persistence.DefaultFieldHandler;
import me.testaccount666.serversystem.userdata.persistence.FieldHandler;
import me.testaccount666.serversystem.userdata.persistence.LocationFieldHandler;
import me.testaccount666.serversystem.userdata.persistence.PrimitiveFieldHandler;
import me.testaccount666.serversystem.userdata.persistence.SaveableField;
import me.testaccount666.serversystem.utils.FieldAccessor;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;

public class PersistenceManager {
    private static final Map<Class<?>, FieldHandler<?>> _TYPE_HANDLERS = new HashMap();
    private static final Map<Class<?>, Map<String, FieldInfo>> _CLASS_FIELD_CACHE = new ConcurrentHashMap();

    public static <T> void registerHandler(Class<T> type, FieldHandler<T> handler) {
        _TYPE_HANDLERS.put(type, handler);
    }

    public static void saveFields(Object object, FileConfiguration config) {
        Class<?> clazz = object.getClass();
        Map<String, FieldInfo> fieldInfoMap = PersistenceManager.getFieldInfoMap(clazz);
        for (FieldInfo fieldInfo : fieldInfoMap.values()) {
            Object value = fieldInfo.getter.apply(object);
            fieldInfo.handler.save(config, fieldInfo.path, value);
        }
    }

    public static void loadFields(Object object, FileConfiguration config) {
        Class<?> clazz = object.getClass();
        Map<String, FieldInfo> fieldInfoMap = PersistenceManager.getFieldInfoMap(clazz);
        for (FieldInfo fieldInfo : fieldInfoMap.values()) {
            Object defaultValue = fieldInfo.getter.apply(object);
            Object value = fieldInfo.handler.load(config, fieldInfo.path, defaultValue);
            fieldInfo.setter.apply(object, value);
        }
    }

    private static Map<String, FieldInfo> getFieldInfoMap(Class<?> clazz) {
        return _CLASS_FIELD_CACHE.computeIfAbsent(clazz, finalCurrentClass -> {
            HashMap<String, FieldInfo> fieldInfoMap = new HashMap<String, FieldInfo>();
            ArrayList<Field> fields = new ArrayList<Field>();
            for (Class currentClass = finalCurrentClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
                fields.addAll(Arrays.asList(currentClass.getDeclaredFields()));
            }
            for (Field field : fields) {
                FieldHandler handler;
                SaveableField annotation = field.getAnnotation(SaveableField.class);
                if (annotation == null) continue;
                String fieldName = field.getName();
                Object path = annotation.path().isEmpty() ? "User." + fieldName : annotation.path();
                Function<Object, Object> getter = FieldAccessor.createGetter(finalCurrentClass, fieldName);
                BiFunction<Object, Object, Object> setter = FieldAccessor.createSetter(finalCurrentClass, fieldName);
                if (annotation.handler() != DefaultFieldHandler.class) {
                    try {
                        handler = annotation.handler().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Failed to instantiate handler for field " + fieldName, exception);
                    }
                } else {
                    Class<?> fieldType = field.getType();
                    handler = _TYPE_HANDLERS.getOrDefault(fieldType, new PrimitiveFieldHandler<Object>(Object.class));
                }
                fieldInfoMap.put(fieldName, new FieldInfo((String)path, getter, setter, handler));
            }
            return fieldInfoMap;
        });
    }

    static {
        PersistenceManager.registerHandler(Boolean.class, new PrimitiveFieldHandler<Boolean>(Boolean.class));
        PersistenceManager.registerHandler(Boolean.TYPE, new PrimitiveFieldHandler<Boolean>(Boolean.TYPE));
        PersistenceManager.registerHandler(Integer.class, new PrimitiveFieldHandler<Integer>(Integer.class));
        PersistenceManager.registerHandler(Integer.TYPE, new PrimitiveFieldHandler<Integer>(Integer.TYPE));
        PersistenceManager.registerHandler(Long.class, new PrimitiveFieldHandler<Long>(Long.class));
        PersistenceManager.registerHandler(Long.TYPE, new PrimitiveFieldHandler<Long>(Long.TYPE));
        PersistenceManager.registerHandler(Double.class, new PrimitiveFieldHandler<Double>(Double.class));
        PersistenceManager.registerHandler(Double.TYPE, new PrimitiveFieldHandler<Double>(Double.TYPE));
        PersistenceManager.registerHandler(String.class, new PrimitiveFieldHandler<String>(String.class));
        PersistenceManager.registerHandler(Location.class, new LocationFieldHandler());
    }

    private record FieldInfo(String path, Function<Object, Object> getter, BiFunction<Object, Object, Object> setter, FieldHandler<Object> handler) {
    }
}

