/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BiDirectionalHashMap<T, V> {
    private final Map<T, V> _keyValueMap = new HashMap<T, V>();
    private final Map<V, T> _valueKeyMap = new HashMap<V, T>();

    public boolean containsKey(T key) {
        return this._keyValueMap.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this._valueKeyMap.containsKey(value);
    }

    public Optional<V> getValue(T key) {
        return Optional.ofNullable(this._keyValueMap.get(key));
    }

    public Optional<T> getKey(V value) {
        return Optional.ofNullable(this._valueKeyMap.get(value));
    }

    public void put(T key, V value) {
        this._keyValueMap.put(key, value);
        this._valueKeyMap.put(value, key);
    }

    public void removeByKey(T key) {
        if (!this._keyValueMap.containsKey(key)) {
            return;
        }
        this._valueKeyMap.remove(this._keyValueMap.get(key));
        this._keyValueMap.remove(key);
    }

    public void removeByValue(V value) {
        if (!this._valueKeyMap.containsKey(value)) {
            return;
        }
        this._keyValueMap.remove(this._valueKeyMap.get(value));
        this._valueKeyMap.remove(value);
    }

    public Set<T> keySet() {
        return this._keyValueMap.keySet();
    }

    public Set<V> valueSet() {
        return this._valueKeyMap.keySet();
    }

    public int size() {
        return this._keyValueMap.size();
    }

    public void clear() {
        this._keyValueMap.clear();
        this._valueKeyMap.clear();
    }
}

