/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public enum ChatColor {
    BLACK,
    DARK_BLUE,
    DARK_GREEN,
    DARK_AQUA,
    DARK_RED,
    DARK_PURPLE,
    GOLD,
    GRAY,
    DARK_GRAY,
    BLUE,
    GREEN,
    AQUA,
    RED,
    LIGHT_PURPLE,
    YELLOW,
    WHITE,
    MAGIC,
    BOLD,
    STRIKETHROUGH,
    UNDERLINE,
    ITALIC,
    RESET;

    public static final char COLOR_CHAR = '\u00a7';
    public static final Pattern HEX_PATTERN;
    private static final Pattern _STRIP_COLOR_PATTERN;
    private static final Logger _LOGGER;
    private final org.bukkit.ChatColor _chatColor = org.bukkit.ChatColor.valueOf((String)this.name());

    public static String translateColor(String text) {
        return ChatColor.translateAlternateColorCodes('&', text);
    }

    public static String translateAlternateColorCodes(char altColorChar, String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        if (text.contains(altColorChar + "#")) {
            try {
                text = ChatColor.replaceHexColor(altColorChar, text);
            }
            catch (Exception exception) {
                _LOGGER.log(Level.WARNING, "Error processing hex colors", exception);
            }
        }
        return org.bukkit.ChatColor.translateAlternateColorCodes((char)altColorChar, (String)text);
    }

    public static String replaceHexColor(char altColorChar, String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Matcher matcher = Pattern.compile(HEX_PATTERN.pattern().replace("&", String.valueOf(altColorChar))).matcher(input);
        while (matcher.find()) {
            matcher.appendReplacement(result, ChatColor.convertHexToMinecraft(matcher.group(2)));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String convertHexToMinecraft(String hexCode) {
        if (hexCode == null || hexCode.length() != 6) {
            return "";
        }
        StringBuilder result = new StringBuilder(14);
        result.append('\u00a7').append('x');
        for (char c : hexCode.toCharArray()) {
            result.append('\u00a7').append(Character.toLowerCase(c));
        }
        return result.toString();
    }

    public static String stripColor(String input) {
        if (input == null) {
            return "";
        }
        return _STRIP_COLOR_PATTERN.matcher(input).replaceAll("");
    }

    public String toString() {
        return this._chatColor.toString();
    }

    @Generated
    public org.bukkit.ChatColor getChatColor() {
        return this._chatColor;
    }

    static {
        HEX_PATTERN = Pattern.compile("(&)?&#([0-9a-fA-F]{6})");
        _STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
        _LOGGER = Logger.getLogger(ChatColor.class.getName());
    }
}

