/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.utils;

import java.lang.reflect.Constructor;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class ConstructorAccessor {
    private ConstructorAccessor() {
    }

    public static <T> Function<Void, T> createConstructor(Class<T> targetClass) {
        try {
            Constructor constructor = targetClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return unused -> {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException exception) {
                    throw new RuntimeException("Failed to create instance of " + targetClass.getName(), exception);
                }
            };
        }
        catch (NoSuchMethodException exception) {
            throw new RuntimeException("Failed to create constructor accessor for " + targetClass.getName(), exception);
        }
    }

    public static <T, P> Function<P, T> createConstructor(Class<T> targetClass, Class<P> paramType) {
        try {
            Constructor constructor = targetClass.getDeclaredConstructor(paramType);
            constructor.setAccessible(true);
            return param -> {
                try {
                    return constructor.newInstance(param);
                }
                catch (ReflectiveOperationException exception) {
                    throw new RuntimeException("Failed to create instance of " + targetClass.getName(), exception);
                }
            };
        }
        catch (NoSuchMethodException exception) {
            throw new RuntimeException("Failed to create constructor accessor for " + targetClass.getName(), exception);
        }
    }

    public static <T, P1, P2> BiFunction<P1, P2, T> createConstructor(Class<T> targetClass, Class<P1> param1Type, Class<P2> param2Type) {
        try {
            Constructor constructor = targetClass.getDeclaredConstructor(param1Type, param2Type);
            constructor.setAccessible(true);
            return (param1, param2) -> {
                try {
                    return constructor.newInstance(param1, param2);
                }
                catch (ReflectiveOperationException exception) {
                    throw new RuntimeException("Failed to create instance of " + targetClass.getName(), exception);
                }
            };
        }
        catch (NoSuchMethodException exception) {
            throw new RuntimeException("Failed to create constructor accessor for " + targetClass.getName(), exception);
        }
    }
}

