/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.utils;

import java.util.Optional;
import java.util.function.UnaryOperator;
import lombok.Generated;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.managers.messages.MessageManager;
import me.testaccount666.serversystem.userdata.User;

public class MessageBuilder {
    private final String _messagePath;
    private final Type _type;
    private final User _receiver;
    private boolean _send = true;
    private boolean _prefix = true;
    private boolean _format = true;
    private UnaryOperator<String> _preModifier = null;
    private UnaryOperator<String> _postModifier = null;
    private String _sender;
    private String _target;
    private String _label;
    private String _syntax;
    private String _language;

    public static MessageBuilder general(String messagePath, User receiver) {
        return MessageBuilder.of(Type.GENERAL, messagePath, receiver);
    }

    public static MessageBuilder command(String messagePath, User receiver) {
        return MessageBuilder.of(Type.COMMAND, messagePath, receiver);
    }

    public static MessageBuilder syntax(String messagePath, User receiver) {
        return MessageBuilder.of(Type.SYNTAX, messagePath, receiver);
    }

    public static MessageBuilder sign(String messagePath, User receiver) {
        return MessageBuilder.of(Type.CLICKABLE_SIGN, messagePath, receiver);
    }

    public static MessageBuilder of(Type type, String messagePath, User receiver) {
        return new MessageBuilder(messagePath, type, receiver);
    }

    public Optional<String> build() {
        String formattedMessage;
        Optional<String> messageOptional;
        String messagePath = switch (this._type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "General." + this._messagePath;
            case 1 -> "Commands." + this._messagePath;
            case 3 -> "Syntax." + this._messagePath;
            case 2 -> "ClickableSigns." + this._messagePath;
        };
        Optional<String> optional = messageOptional = this._language != null ? MessageManager.getMessage(this._receiver, messagePath, this._language) : MessageManager.getMessage(this._receiver, messagePath);
        if (messageOptional.isEmpty()) {
            if (this._messagePath.equalsIgnoreCase("ErrorOccurred")) {
                ServerSystem.getLog().severe("'ErrorOccurred' message could not be found, this is a critical error!");
                ServerSystem.getLog().severe("Please report this error to the server administrator!");
                this._receiver.sendMessage("Something went seriously wrong! Please contact an administrator of this server!");
                return Optional.empty();
            }
            MessageBuilder.general("ErrorOccurred", this._receiver).build();
            return Optional.empty();
        }
        String message = messageOptional.get();
        if (this._preModifier != null) {
            message = (String)this._preModifier.apply(message);
        }
        if (this._sender != null) {
            message = message.replace("<SENDER>", this._sender);
        }
        if (this._target == null) {
            this._target = this._receiver.getName().orElse("Unknown");
        }
        if (this._syntax != null) {
            Optional<String> syntaxOptional = MessageBuilder.syntax(this._syntax, this._receiver).sender(this._sender).prefix(false).target(this._target).label(this._label).send(false).build();
            message = syntaxOptional.isPresent() ? message.replace("<USAGE>", syntaxOptional.get()) : message.replace("<USAGE>", "!!ERROR!!");
        }
        if (this._postModifier != null) {
            message = (String)this._postModifier.apply(message);
        }
        String string = formattedMessage = this._format ? MessageManager.formatMessage(message, this._receiver, this._target, this._label, this._prefix) : message;
        if (this._send) {
            this._receiver.sendMessage(formattedMessage);
        }
        return Optional.of(formattedMessage);
    }

    @Generated
    private MessageBuilder(String messagePath, Type type, User receiver) {
        this._messagePath = messagePath;
        this._type = type;
        this._receiver = receiver;
    }

    @Generated
    public MessageBuilder send(boolean _send) {
        this._send = _send;
        return this;
    }

    @Generated
    public MessageBuilder prefix(boolean _prefix) {
        this._prefix = _prefix;
        return this;
    }

    @Generated
    public MessageBuilder format(boolean _format) {
        this._format = _format;
        return this;
    }

    @Generated
    public MessageBuilder preModifier(UnaryOperator<String> _preModifier) {
        this._preModifier = _preModifier;
        return this;
    }

    @Generated
    public MessageBuilder postModifier(UnaryOperator<String> _postModifier) {
        this._postModifier = _postModifier;
        return this;
    }

    @Generated
    public MessageBuilder sender(String _sender) {
        this._sender = _sender;
        return this;
    }

    @Generated
    public MessageBuilder target(String _target) {
        this._target = _target;
        return this;
    }

    @Generated
    public MessageBuilder label(String _label) {
        this._label = _label;
        return this;
    }

    @Generated
    public MessageBuilder syntax(String _syntax) {
        this._syntax = _syntax;
        return this;
    }

    @Generated
    public MessageBuilder language(String _language) {
        this._language = _language;
        return this;
    }

    public static enum Type {
        GENERAL,
        COMMAND,
        CLICKABLE_SIGN,
        SYNTAX;

    }
}

