/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.utils;

import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Version
implements Comparable<Version> {
    private final String _version;

    public Version(String version) {
        if (version == null || version.trim().isEmpty()) {
            throw new IllegalArgumentException("Version string cannot be null or empty");
        }
        String normalizedVersion = version.trim();
        if (!normalizedVersion.matches("^\\d+(\\.\\d+)*$")) {
            throw new IllegalArgumentException("Invalid version format: " + version + ". Expected format: x.y.z (numeric segments separated by dots)");
        }
        this._version = normalizedVersion;
    }

    @Override
    public int compareTo(@NotNull Version other) {
        String[] thisVersion = this._version.split("\\.");
        String[] otherVersion = other._version.split("\\.");
        for (int index = 0; index < Math.min(thisVersion.length, otherVersion.length); ++index) {
            try {
                int thisVersionInt = Integer.parseInt(thisVersion[index]);
                int otherVersionInt = Integer.parseInt(otherVersion[index]);
                if (thisVersionInt == otherVersionInt) continue;
                return Integer.compare(thisVersionInt, otherVersionInt);
            }
            catch (NumberFormatException exception) {
                throw new IllegalStateException("Invalid numeric segment in version: " + this._version + " or " + other._version, exception);
            }
        }
        return Integer.compare(thisVersion.length, otherVersion.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version version = (Version)obj;
        return this.compareTo(version) == 0;
    }

    public int hashCode() {
        return Objects.hash(this._version);
    }

    public String toString() {
        return this._version;
    }

    @Generated
    public String getVersion() {
        return this._version;
    }
}

