/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses;

import com.finderfeed.fdbosses.FDBosses;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthEntity;
import com.finderfeed.fdbosses.init.BossConfigs;
import com.finderfeed.fdbosses.packets.PosLevelEventPacket;
import com.finderfeed.fdlib.network.FDPacketHandler;
import com.finderfeed.fdlib.util.FDUtil;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class BossUtil {
    public static final TargetingConditions ALL = TargetingConditions.m_148353_().m_26888_(p -> true).m_148355_().m_26893_();
    public static final int CHESED_GET_BLOCKS_FROM_EARTH_EVENT = 1;
    public static final int RADIAL_EARTHQUAKE_PARTICLES = 2;
    public static final int ROCKFALL_PARTICLES = 3;
    public static final int CHESED_RAY_EXPLOSION = 4;
    public static final int CHESED_RAY_ATTACK_SMOKE = 5;
    public static final int CHESED_BOOM_PARTICLES = 6;
    public static final int MALKUTH_CANNON_SHOOT = 7;
    public static final int MALKUTH_SWORD_CHARGE_PARTICLES = 8;
    public static final int MALKUTH_FLOAT_PARTICLES = 9;
    public static final int MALKUTH_FIREBALL_EXPLODE = 10;
    public static final int MALKUTH_VOLCANO_ERRUPTION = 11;
    public static final int MALKUTH_SWORD_INSERT_PARTICLES = 12;
    public static final int MALKUTH_PLAYER_FIREBALL_EXPLODE = 13;
    public static final int CHESED_ADD_ROCKFALL_PARTICLE_EMITTER = 14;

    public static CompoundTag getOrCreateTag(CompoundTag main, String name) {
        if (!main.m_128441_(name)) {
            main.m_128365_(name, (Tag)new CompoundTag());
        }
        return main.m_128469_(name);
    }

    public static CompoundTag getPlayerTag(Player player) {
        CompoundTag persistentData = player.getPersistentData();
        return BossUtil.getOrCreateTag(persistentData, "fdbosses_data");
    }

    public static Vec3 matTransformDirectionVec3(Matrix4f mat, Vec3 v) {
        Vector3f v1 = mat.transformDirection((float)v.f_82479_, (float)v.f_82480_, (float)v.f_82481_, new Vector3f());
        return new Vec3((double)v1.x, (double)v1.y, (double)v1.z);
    }

    public static Vec3 calculateMortarProjectileVelocity(Vec3 startPos, Vec3 endPos, double gravity, int tickTravelTime) {
        Vec3 between = endPos.m_82546_(startPos);
        double horizontalDistance = Math.sqrt(between.f_82479_ * between.f_82479_ + between.f_82481_ * between.f_82481_);
        double d = between.f_82480_;
        double horizontalSpeed = horizontalDistance / (double)tickTravelTime;
        double verticalSpeed = (gravity * (double)tickTravelTime * (double)tickTravelTime / 2.0 - d) / (double)(-tickTravelTime);
        Vec3 result = between.m_82542_(1.0, 0.0, 1.0).m_82541_().m_82542_(horizontalSpeed, 0.0, horizontalSpeed).m_82520_(0.0, verticalSpeed, 0.0);
        return result;
    }

    public static float transformDamage(Level level, float damage) {
        Difficulty difficulty = level.m_46791_();
        switch (difficulty) {
            case EASY: {
                return BossConfigs.BOSS_CONFIG.get().easyDifficultyBossDamageMultiplier * damage;
            }
            case NORMAL: {
                return BossConfigs.BOSS_CONFIG.get().normalDifficultyBossDamageMultiplier * damage;
            }
            case HARD: {
                return BossConfigs.BOSS_CONFIG.get().hardDifficultyBossDamageMultiplier * damage;
            }
            case PEACEFUL: {
                return BossConfigs.BOSS_CONFIG.get().peacefulDifficultyBossDamageMuliplier * damage;
            }
        }
        return BossConfigs.BOSS_CONFIG.get().hardDifficultyBossDamageMultiplier * damage;
    }

    public static void applyGravity(Entity entity, double gravity) {
        entity.m_20256_(entity.m_20184_().m_82520_(0.0, -gravity, 0.0));
    }

    public static double getToolDamage(LivingEntity owner, Entity target, ItemStack itemStack) {
        AttributeInstance attribute = owner.m_21051_(Attributes.f_22281_);
        double base = attribute.m_22115_();
        Multimap modifiers = itemStack.m_41638_(EquipmentSlot.MAINHAND);
        if (modifiers.containsKey((Object)Attributes.f_22281_)) {
            Collection attributes = modifiers.get((Object)Attributes.f_22281_);
            Map<AttributeModifier.Operation, List<AttributeModifier>> operationAttributes = BossUtil.modifierCollectionToOperationMap(attributes);
            for (AttributeModifier mod : operationAttributes.get(AttributeModifier.Operation.ADDITION)) {
                base += mod.m_22218_();
            }
            double damage = base;
            for (AttributeModifier mod : operationAttributes.get(AttributeModifier.Operation.MULTIPLY_BASE)) {
                damage += base * mod.m_22218_();
            }
            for (AttributeModifier mod : operationAttributes.get(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
                damage *= 1.0 + mod.m_22218_();
            }
            return damage += (double)EnchantmentHelper.m_44833_((ItemStack)itemStack, (MobType)MobType.f_21640_);
        }
        return 0.0;
    }

    private static Map<AttributeModifier.Operation, List<AttributeModifier>> modifierCollectionToOperationMap(Collection<AttributeModifier> collection) {
        LinkedHashMap<AttributeModifier.Operation, List<AttributeModifier>> operationListMap = new LinkedHashMap<AttributeModifier.Operation, List<AttributeModifier>>();
        operationListMap.put(AttributeModifier.Operation.ADDITION, new ArrayList());
        operationListMap.put(AttributeModifier.Operation.MULTIPLY_BASE, new ArrayList());
        operationListMap.put(AttributeModifier.Operation.MULTIPLY_TOTAL, new ArrayList());
        for (AttributeModifier mod : collection) {
            ((List)operationListMap.get(mod.m_22217_())).add(mod);
        }
        return operationListMap;
    }

    public static Predicate<Entity> entityInVerticalRadiusPredicate(Vec3 pos, float radius) {
        return entity -> {
            double z;
            double x = pos.f_82479_ - entity.m_20185_();
            return x * x + (z = pos.f_82481_ - entity.m_20189_()) * z <= (double)(radius * radius);
        };
    }

    public static void chesedRockfallEmitter(ServerLevel level, Vec3 pos, double radius, int chesedEntityId) {
        BossUtil.posEvent(level, pos, 14, chesedEntityId, radius);
    }

    public static void malkuthSwordsInsertParticles(ServerLevel serverLevel, Vec3 pos, double radius, int malkuthEntityId) {
        BossUtil.posEvent(serverLevel, pos, 12, malkuthEntityId, radius);
    }

    public static void volcanoErruptionParticles(ServerLevel serverLevel, Vec3 pos, int radius16, double sendRadius) {
        BossUtil.posEvent(serverLevel, pos, 11, radius16, sendRadius);
    }

    public static void malkuthFireballExplosionParticles(ServerLevel serverLevel, Vec3 pos, MalkuthAttackType type) {
        BossUtil.posEvent(serverLevel, pos, 10, type.isFire() ? 0 : 1, 60.0);
    }

    public static void malkuthPlayerFireballExplosionParticles(ServerLevel serverLevel, Vec3 pos, MalkuthAttackType type) {
        BossUtil.posEvent(serverLevel, pos, 13, type.isFire() ? 0 : 1, 60.0);
    }

    public static void malkuthFloatParticles(ServerLevel serverLevel, MalkuthEntity malkuthEntity) {
        BossUtil.posEvent(serverLevel, malkuthEntity.m_20182_(), 9, malkuthEntity.m_19879_(), 60.0);
    }

    public static void malkuthCannonShoot(ServerLevel serverLevel, MalkuthAttackType malkuthAttackType, Vec3 pos, Vec3 direction, double radius) {
        int data = FDUtil.encodeDirection((Vec3)direction);
        data <<= 1;
        if (malkuthAttackType.isFire()) {
            ++data;
        }
        BossUtil.posEvent(serverLevel, pos, 7, data, radius);
    }

    public static void malkuthSwordChargeParticles(ServerLevel serverLevel, MalkuthAttackType malkuthAttackType, MalkuthEntity malkuthEntity, double radius) {
        Vec3 yesIEncodeEnumIntoVec3DontJudgeMe = malkuthAttackType.isFire() ? new Vec3(1.0, 0.0, 0.0) : new Vec3(-1.0, 0.0, 0.0);
        yesIEncodeEnumIntoVec3DontJudgeMe = yesIEncodeEnumIntoVec3DontJudgeMe.m_82549_(malkuthEntity.m_20182_());
        BossUtil.posEvent(serverLevel, yesIEncodeEnumIntoVec3DontJudgeMe, 8, malkuthEntity.m_19879_(), radius);
    }

    public static void chesedRaySmoke(ServerLevel level, Vec3 pos, Vec3 direction, double radius) {
        BossUtil.posEvent(level, pos, 5, FDUtil.encodeDirection((Vec3)direction), radius);
    }

    public static void chesedBoomParticles(ServerLevel level, Vec3 pos, int radiusFromCenter, double packetRadius) {
        BossUtil.posEvent(level, pos, 6, radiusFromCenter, packetRadius);
    }

    public static void chesedRayExplosion(ServerLevel level, Vec3 pos, Vec3 direction, double radius, int particlesCount, float sizeModifier) {
        if (particlesCount > 15) {
            throw new RuntimeException("Cannot encode more than 16 particles count");
        }
        if (sizeModifier > 1.0f) {
            throw new RuntimeException("Cannot encode size modifier > 1");
        }
        direction = direction.m_82541_();
        int dx = (int)Math.round((direction.f_82479_ + 1.0) / 2.0 * 255.0);
        int dy = (int)Math.round((direction.f_82480_ + 1.0) / 2.0 * 255.0);
        int dz = (int)Math.round((direction.f_82481_ + 1.0) / 2.0 * 255.0);
        int size = Math.round(sizeModifier * 15.0f);
        int data = 0;
        data |= size << 28;
        data |= particlesCount << 24;
        data |= dx << 16;
        data |= dy << 8;
        BossUtil.posEvent(level, pos, 4, data |= dz, radius);
    }

    public static void posEvent(ServerLevel level, Vec3 pos, int event, int data, double radius) {
        FDPacketHandler.INSTANCE.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_, (double)radius, (ResourceKey)level.m_46472_())), (Object)new PosLevelEventPacket(pos, event, data));
    }

    public static float easeInBack(float x) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return c3 * x * x * x - c1 * x * x;
    }

    public static boolean itemContainsModifierForAttribute(ItemStack itemStack, Attribute attributeHolder) {
        Multimap modifiers = itemStack.m_41638_(EquipmentSlot.MAINHAND);
        return modifiers.containsKey((Object)attributeHolder);
    }

    public static class StructureTags {
        public static final TagKey<Structure> EYE_OF_CHESED_LOCATED = StructureTags.create("eye_of_chesed_located");
        public static final TagKey<Structure> EYE_OF_MALKUTH_LOCATED = StructureTags.create("eye_of_malkuth_located");

        private static TagKey<Structure> create(String id) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)FDBosses.location(id));
        }
    }
}

