/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.recipes;

import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.content.data_components.ItemCoreDataComponent;
import com.finderfeed.fdbosses.content.items.WeaponCoreItem;
import com.finderfeed.fdbosses.init.BossRecipeSerializers;
import com.finderfeed.fdlib.data_structures.Pair;
import com.finderfeed.fdlib.systems.stream_codecs.NetworkCodec;
import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WeaponCoreRecipe
implements CraftingRecipe {
    public final ItemCoreDataComponent.CoreType coreType;
    private ResourceLocation id;

    public WeaponCoreRecipe(ResourceLocation id, ItemCoreDataComponent.CoreType coreType) {
        this.coreType = coreType;
        this.id = id;
    }

    protected WeaponCoreRecipe(ResourceLocation location, String s) {
        this.coreType = ItemCoreDataComponent.CoreType.valueOf(s);
        this.id = location;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public boolean matches(CraftingContainer input, Level level) {
        Pair<ItemStack, ItemStack> weaponAndCore = this.getWeaponAndCore(input);
        return weaponAndCore != null;
    }

    public ItemStack assemble(CraftingContainer input, RegistryAccess registryAccess) {
        Pair<ItemStack, ItemStack> weaponAndCore = this.getWeaponAndCore(input);
        if (weaponAndCore == null) {
            return ItemStack.f_41583_;
        }
        ItemStack weapon = (ItemStack)weaponAndCore.first;
        ItemStack coreStack = (ItemStack)weaponAndCore.second;
        if (weapon != null && coreStack != null) {
            ItemStack result = weapon.m_41777_();
            WeaponCoreItem.setItemCore(this.coreType, result);
            return result;
        }
        return ItemStack.f_41583_;
    }

    private Pair<ItemStack, ItemStack> getWeaponAndCore(CraftingContainer input) {
        ItemStack weapon = null;
        ItemStack coreStack = null;
        for (ItemStack itemStack : input.m_280657_()) {
            Item item = itemStack.m_41720_();
            if (!(item instanceof WeaponCoreItem) && BossUtil.itemContainsModifierForAttribute(itemStack, Attributes.f_22281_)) {
                if (weapon != null) {
                    return null;
                }
                ItemCoreDataComponent.CoreType coreType = WeaponCoreItem.getItemCore(itemStack);
                if (coreType != null && coreType == this.coreType) {
                    return null;
                }
                weapon = itemStack;
                continue;
            }
            if (item instanceof WeaponCoreItem) {
                WeaponCoreItem weaponCoreItem = (WeaponCoreItem)item;
                if (coreStack != null || weaponCoreItem.coreType != this.coreType) {
                    return null;
                }
                coreStack = itemStack;
                continue;
            }
            if (itemStack.m_41619_()) continue;
            return null;
        }
        if (weapon == null || coreStack == null) {
            return null;
        }
        return new Pair(weapon, coreStack);
    }

    public boolean m_8004_(int x, int y) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return BossRecipeSerializers.WEAPON_CORE.get();
    }

    public static class Serializer
    implements RecipeSerializer<WeaponCoreRecipe> {
        public static final NetworkCodec<WeaponCoreRecipe> STREAM_CODEC = NetworkCodec.composite((NetworkCodec)NetworkCodec.RESOURCE_LOCATION, WeaponCoreRecipe::m_6423_, (NetworkCodec)NetworkCodec.STRING, v -> v.coreType.name(), WeaponCoreRecipe::new);

        public WeaponCoreRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            String coreTypeName = jsonObject.get("core_type").getAsString();
            return new WeaponCoreRecipe(resourceLocation, coreTypeName);
        }

        @Nullable
        public WeaponCoreRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            return (WeaponCoreRecipe)STREAM_CODEC.fromNetwork(friendlyByteBuf);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, WeaponCoreRecipe weaponCoreRecipe) {
            STREAM_CODEC.toNetwork(friendlyByteBuf, (Object)weaponCoreRecipe);
        }
    }
}

