/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.client;

import com.finderfeed.fdbosses.FDBosses;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.joml.Vector2f;

public class BossRenderUtil {
    public static final ResourceLocation BOSS_TOOLTIP = FDBosses.location("textures/gui/boss_screen_tooltip.png");
    public static final int EDGE_SIZE = 7;

    public static Vector2f renderBossScreenTooltip(GuiGraphics graphics, Component component, float x, float y, float desiredTextWidth, int textColor, float textScale) {
        Window window = Minecraft.getInstance().getWindow();
        return BossRenderUtil.renderBossScreenTooltip(graphics, component, x, y, desiredTextWidth, textColor, textScale, 0.0f, 0.0f, window.getGuiScaledWidth(), window.getGuiScaledHeight());
    }

    public static Vector2f renderBossScreenTooltip(GuiGraphics graphics, Component component, float x, float y, float desiredTextWidth, int textColor, float textScale, float borderXStart, float borderYStart, float borderXEnd, float borderYEnd) {
        Font font = Minecraft.getInstance().font;
        Objects.requireNonNull(font);
        float lineHeight = 9.0f * textScale;
        List charSequences = font.getSplitter().splitLines((FormattedText)component, Math.round(desiredTextWidth / textScale), Style.EMPTY);
        float height = (float)charSequences.size() * lineHeight;
        float width = 0.0f;
        for (FormattedText sequence : charSequences) {
            width = Math.max((float)font.width(sequence), width);
        }
        Vector2f v = BossRenderUtil.renderBossScreenTooltip(graphics.pose(), x, y, width + lineHeight, height + lineHeight, borderXStart, borderYStart, borderXEnd, borderYEnd);
        int index = 0;
        for (FormattedText sequence : charSequences) {
            FDRenderUtil.renderScaledText((GuiGraphics)graphics, (FormattedCharSequence)Language.getInstance().getVisualOrder(sequence), (float)(v.x + lineHeight / 2.0f), (float)(v.y + (float)index * lineHeight + lineHeight / 2.0f), (float)textScale, (boolean)false, (int)textColor);
            ++index;
        }
        return v;
    }

    public static Vector2f renderBossScreenTooltip(PoseStack matrices, float x, float y, float inWidth, float inHeight) {
        Window window = Minecraft.getInstance().getWindow();
        return BossRenderUtil.renderBossScreenTooltip(matrices, x, y, inWidth, inHeight, 0.0f, 0.0f, window.getGuiScaledWidth(), window.getGuiScaledHeight());
    }

    public static Vector2f renderBossScreenTooltip(PoseStack matrices, float x, float y, float inWidth, float inHeight, float borderXStart, float borderYStart, float borderXEnd, float borderYEnd) {
        FDRenderUtil.bindTexture((ResourceLocation)BOSS_TOOLTIP);
        float edgeWidth = 7.0f;
        float edgeHeight = 7.0f;
        float texWidth = 16.0f;
        float texHeight = 16.0f;
        float xRenderStart = Mth.clamp((float)x, (float)borderXStart, (float)(borderXEnd - inWidth - edgeWidth * 2.0f));
        float yRenderStart = Mth.clamp((float)y, (float)borderYStart, (float)(borderYEnd - inHeight - edgeHeight * 2.0f));
        FDRenderUtil.blitWithBlend((PoseStack)matrices, (float)xRenderStart, (float)yRenderStart, (float)edgeWidth, (float)edgeHeight, (float)0.0f, (float)0.0f, (float)edgeWidth, (float)edgeHeight, (float)texWidth, (float)texHeight, (float)0.0f, (float)1.0f);
        FDRenderUtil.blitWithBlend((PoseStack)matrices, (float)(xRenderStart + inWidth + edgeWidth), (float)yRenderStart, (float)edgeWidth, (float)edgeHeight, (float)edgeWidth, (float)0.0f, (float)edgeWidth, (float)edgeHeight, (float)texWidth, (float)texHeight, (float)0.0f, (float)1.0f);
        FDRenderUtil.blitWithBlend((PoseStack)matrices, (float)xRenderStart, (float)(yRenderStart + inHeight + edgeHeight), (float)edgeWidth, (float)edgeHeight, (float)0.0f, (float)edgeHeight, (float)edgeWidth, (float)edgeHeight, (float)texWidth, (float)texHeight, (float)0.0f, (float)1.0f);
        FDRenderUtil.blitWithBlend((PoseStack)matrices, (float)(xRenderStart + inWidth + edgeWidth), (float)(yRenderStart + inHeight + edgeHeight), (float)edgeWidth, (float)edgeHeight, (float)edgeWidth, (float)edgeHeight, (float)edgeWidth, (float)edgeHeight, (float)texWidth, (float)texHeight, (float)0.0f, (float)1.0f);
        FDRenderUtil.blitWithBlend((PoseStack)matrices, (float)(xRenderStart + edgeWidth), (float)yRenderStart, (float)inWidth, (float)7.0f, (float)14.0f, (float)0.0f, (float)1.0f, (float)7.0f, (float)texWidth, (float)texHeight, (float)0.0f, (float)1.0f);
        FDRenderUtil.blitWithBlend((PoseStack)matrices, (float)(xRenderStart + edgeWidth), (float)(yRenderStart + inHeight + edgeHeight), (float)inWidth, (float)7.0f, (float)15.0f, (float)0.0f, (float)1.0f, (float)7.0f, (float)texWidth, (float)texHeight, (float)0.0f, (float)1.0f);
        FDRenderUtil.blitWithBlend((PoseStack)matrices, (float)xRenderStart, (float)(yRenderStart + edgeHeight), (float)7.0f, (float)inHeight, (float)0.0f, (float)14.0f, (float)7.0f, (float)1.0f, (float)texWidth, (float)texHeight, (float)0.0f, (float)1.0f);
        FDRenderUtil.blitWithBlend((PoseStack)matrices, (float)(xRenderStart + edgeWidth + inWidth), (float)(yRenderStart + edgeHeight), (float)7.0f, (float)inHeight, (float)0.0f, (float)15.0f, (float)7.0f, (float)1.0f, (float)texWidth, (float)texHeight, (float)0.0f, (float)1.0f);
        FDRenderUtil.blitWithBlend((PoseStack)matrices, (float)(xRenderStart + edgeWidth), (float)(yRenderStart + edgeHeight), (float)inWidth, (float)inHeight, (float)15.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)texWidth, (float)texHeight, (float)0.0f, (float)1.0f);
        Vector2f toReturn = new Vector2f(xRenderStart + edgeWidth, yRenderStart + edgeHeight);
        return toReturn;
    }
}

