/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.client.boss_screen;

import com.finderfeed.fdbosses.FDBosses;
import com.finderfeed.fdbosses.client.boss_screen.BaseBossScreen;
import com.finderfeed.fdbosses.client.boss_screen.screen_definitions.BossScreenOptions;
import com.finderfeed.fdbosses.client.boss_screen.util.KilledASefirotException;
import com.finderfeed.fdbosses.client.boss_screen.util.TimedText;
import com.finderfeed.fdbosses.init.BossAnims;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossModels;
import com.finderfeed.fdlib.FDClientPacketExecutables;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationSystem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.FDButton;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.util.FDButtonTextures;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.util.WidgetTexture;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.joml.Vector2f;

public class ChesedBossScreen
extends BaseBossScreen {
    private static FDModel chesed;
    private AnimationSystem animationSystem;
    private int hurtTime = 0;
    private static final Component[] hurtTexts;
    private int maxHealth;
    private int remainingHealth = this.maxHealth = 10;
    private boolean renderBoss = false;
    private float bossX;
    private float bossY;
    private TimedText hurtText;

    public ChesedBossScreen(int bossSpawnerId, BossScreenOptions options) {
        super(bossSpawnerId, options);
    }

    @Override
    protected void init() {
        super.init();
        if (chesed == null) {
            chesed = new FDModel(BossModels.CHESED.get());
        }
        this.hurtText = new TimedText();
        this.hurtTime = 0;
        this.animationSystem = new AnimationSystem(this){

            public void onAnimationStart(String s, AnimationTicker animationTicker) {
            }

            public void onAnimationStop(String s) {
            }

            public void onFreeze(boolean b) {
            }

            public void onVariableAdded(String s, float v) {
            }
        };
        this.animationSystem.startAnimation("APPEAR", AnimationTicker.builder(BossAnims.CHESED_SCREEN_APPEAR).setLoopMode(Animation.LoopMode.ONCE).setToNullTransitionTime(0).build());
        Vector2f anchor = this.getAnchor(0.0f, 0.5f);
        float offsetX = this.getBossMenuXStart() / 2.0f;
        float offsetY = 100.0f;
        this.bossX = anchor.x + offsetX;
        this.bossY = anchor.y + offsetY;
        FDButton button = new FDButton((Screen)this, this.bossX - 23.0f, this.bossY - 90.0f, 50.0f, 50.0f).setOnClickAction((fdWidget, v, v1, i) -> {
            if (this.hurtTime == 0 && this.remainingHealth > 0) {
                FDClientPacketExecutables.playsoundInEars((SoundEvent)SoundEvents.GENERIC_HURT, (float)1.0f, (float)1.0f);
                this.animationSystem.startAnimation("HURT", AnimationTicker.builder(BossAnims.CHESED_IDLE).setLoopMode(Animation.LoopMode.ONCE).startTime(30.0f).setSpeed(20.0f).build());
                this.hurtTime = 10;
                int textId = this.maxHealth - this.remainingHealth;
                int time = 60;
                if (textId == hurtTexts.length - 1) {
                    time = Integer.MAX_VALUE;
                }
                this.hurtText.setText(hurtTexts[textId], time);
                this.remainingHealth = Mth.clamp((int)(this.remainingHealth - 1), (int)0, (int)Integer.MAX_VALUE);
                if (this.remainingHealth == 0) {
                    this.removeWidget((GuiEventListener)fdWidget);
                    this.animationSystem.startAnimation("IDLE", AnimationTicker.builder(BossAnims.CHESED_DEATH).build());
                    FDButton crashButton = new FDButton((Screen)this, this.bossX - 55.0f, this.bossY - 40.0f, 110.0f, 24.0f).setTexture(new FDButtonTextures(new WidgetTexture(FDBosses.location("textures/gui/medium_button.png")), new WidgetTexture(FDBosses.location("textures/gui/medium_button_selected.png"), 1.0f, 1.0f))).setText((Component)Component.translatable((String)"fdbosses.word.crash_game").withStyle(Style.EMPTY.withColor(this.getBaseStringColor())), 110, 1.0f, true, 0.0f, 1.0f).setOnClickAction((fdWidget1, v2, v11, i1) -> {
                        throw new KilledASefirotException("That's what you get for messing with Chesed! I warned you!");
                    });
                    this.addRenderableWidget((GuiEventListener)crashButton);
                }
            }
            return true;
        });
        this.addWidget((GuiEventListener)button);
    }

    @Override
    public Component getBossName() {
        return BossEntities.CHESED.get().getDescription();
    }

    @Override
    public int getBaseStringColor() {
        return 0x55CCFF;
    }

    @Override
    public void tick() {
        super.tick();
        this.animationSystem.tick();
        AnimationTicker ticker = this.animationSystem.getTicker("IDLE");
        if (ticker == null) {
            this.animationSystem.startAnimation("IDLE", AnimationTicker.builder(BossAnims.CHESED_IDLE).build());
        }
        this.hurtTime = Mth.clamp((int)(this.hurtTime - 1), (int)0, (int)Integer.MAX_VALUE);
        this.hurtText.tick();
    }

    @Override
    protected void renderBoss(GuiGraphics graphics, float mx, float my, float pticks) {
        PoseStack matrices = graphics.pose();
        this.animationSystem.applyAnimations(chesed, FDRenderUtil.tryGetPartialTickIgnorePause());
        matrices.pushPose();
        matrices.translate(0.0f, 0.0f, -100.0f);
        int overlay = this.hurtTime > 0 ? 3 : OverlayTexture.NO_OVERLAY;
        FDRenderUtil.renderFDModelInScreen((PoseStack)matrices, (FDModel)chesed, (float)this.bossX, (float)this.bossY, (float)0.0f, (float)3.3379424f, (float)0.0f, (float)50.0f, (int)0xF000F0, (int)overlay, (RenderType)RenderType.entityCutout((ResourceLocation)FDBosses.location("textures/entities/chesed.png")));
        FDRenderUtil.renderFDModelInScreen((PoseStack)matrices, (FDModel)chesed, (float)this.bossX, (float)this.bossY, (float)0.0f, (float)3.3379424f, (float)0.0f, (float)50.0f, (int)0xF000F0, (int)overlay, (RenderType)RenderType.eyes((ResourceLocation)FDBosses.location("textures/entities/chesed_crystals.png")));
        matrices.popPose();
        Component text = this.hurtText.text;
        if (text != null) {
            int i = 0;
            for (FormattedCharSequence sequence : this.font.split((FormattedText)text, 200)) {
                float f = this.bossX - (float)this.font.width(sequence) / 2.0f;
                Objects.requireNonNull(this.font);
                FDRenderUtil.renderScaledText((GuiGraphics)graphics, (FormattedCharSequence)sequence, (float)f, (float)(this.bossY - 200.0f + (float)(i * 9)), (float)1.0f, (boolean)true, (int)this.getBaseStringColor());
                ++i;
            }
        }
    }

    public float getScreenWidth() {
        return 0.0f;
    }

    public float getScreenHeight() {
        return 0.0f;
    }

    static {
        hurtTexts = new Component[]{Component.translatable((String)"fdbosses.word.ouch"), Component.translatable((String)"fdbosses.word.that_hurts"), Component.translatable((String)"fdbosses.word.stop_it"), Component.translatable((String)"fdbosses.word.you_are_getting_on_my_nerves"), Component.translatable((String)"fdbosses.word.i_said_stop"), Component.translatable((String)"fdbosses.word.consequences"), Component.translatable((String)"fdbosses.word.does_that_not_scare_you"), Component.translatable((String)"fdbosses.word.ok_listen"), Component.translatable((String)"fdbosses.word.no_wait"), Component.translatable((String)"fdbosses.word.killed_chesed_in_screen").withStyle(ChatFormatting.RED)};
    }
}

