/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.client.particles.arc_preparation_particle;

import com.finderfeed.fdbosses.client.particles.arc_preparation_particle.ArcAttackPreparationParticleOptions;
import com.finderfeed.fdlib.systems.particle.FDParticleRenderType;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ArcAttackPreparationParticle
extends Particle {
    private ArcAttackPreparationParticleOptions options;
    public static final ParticleRenderType RENDER_TYPE = new FDParticleRenderType(){

        public void end() {
            RenderSystem.setShader(GameRenderer::getParticleShader);
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableCull();
        }

        @Nullable
        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.disableCull();
            return tesselator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        }
    };

    public ArcAttackPreparationParticle(ArcAttackPreparationParticleOptions options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd);
        this.options = options;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.lifetime = options.getAttackChargeTime() + options.getFadeOut();
    }

    public void render(VertexConsumer vertex, Camera camera, float pticks) {
        Vec3 thisPos = FDMathUtil.interpolateVectors((Vec3)new Vec3(this.xo, this.yo, this.zo), (Vec3)new Vec3(this.x, this.y, this.z), (float)pticks);
        Vec3 camPos = camera.getPosition();
        Vec3 pos = thisPos.subtract(camPos);
        Vec3 hdir = this.options.getHorizontalDirection().multiply(1.0, 0.0, 1.0).normalize().multiply((double)this.options.getLength(), (double)this.options.getLength(), (double)this.options.getLength());
        float distanceModifier = FDEasings.easeOut((float)Math.clamp(((float)this.age + pticks) / (float)this.options.getFadeIn(), 0.0f, 1.0f));
        float attackPreparationModifier = Math.clamp(((float)this.age + pticks) / (float)this.options.getAttackChargeTime(), 0.0f, 1.0f);
        Vec3 toPos2 = hdir.yRot(this.options.getHalfAttackAngle());
        Vec3 toPos3 = hdir.yRot(-this.options.getHalfAttackAngle());
        Vec3 toPos2p = hdir.yRot(this.options.getHalfAttackAngle());
        Vec3 toPos3p = hdir.yRot(-this.options.getHalfAttackAngle());
        Vec3 pos2 = pos.add(toPos2.multiply((double)distanceModifier, (double)distanceModifier, (double)distanceModifier));
        Vec3 pos3 = pos.add(toPos3.multiply((double)distanceModifier, (double)distanceModifier, (double)distanceModifier));
        Vec3 pos2p = pos.add(toPos2p.multiply((double)attackPreparationModifier, (double)attackPreparationModifier, (double)attackPreparationModifier));
        Vec3 pos3p = pos.add(toPos3p.multiply((double)attackPreparationModifier, (double)attackPreparationModifier, (double)attackPreparationModifier));
        Vec3 center = pos.add(hdir.multiply((double)distanceModifier, (double)distanceModifier, (double)distanceModifier));
        Vec3 centerp = pos.add(hdir.multiply((double)attackPreparationModifier, (double)attackPreparationModifier, (double)attackPreparationModifier));
        FDColor color = this.options.getColor();
        float fadeOutP = 1.0f;
        if (this.age - this.options.getAttackChargeTime() >= 0) {
            fadeOutP = 1.0f - Math.clamp(((float)this.age + pticks - (float)this.options.getAttackChargeTime()) / (float)this.options.getFadeOut(), 0.0f, 1.0f);
        }
        float colmod = 0.75f;
        vertex.addVertex((float)pos.x, (float)pos.y, (float)pos.z).setColor(color.r * colmod, color.g * colmod, color.b * colmod, color.a * fadeOutP);
        vertex.addVertex((float)pos2.x, (float)pos2.y, (float)pos2.z).setColor(color.r * colmod, color.g * colmod, color.b * colmod, color.a * fadeOutP);
        vertex.addVertex((float)center.x, (float)center.y, (float)center.z).setColor(color.r * colmod, color.g * colmod, color.b * colmod, color.a * fadeOutP);
        vertex.addVertex((float)pos.x, (float)pos.y, (float)pos.z).setColor(color.r * colmod, color.g * colmod, color.b * colmod, color.a * fadeOutP);
        vertex.addVertex((float)pos3.x, (float)pos3.y, (float)pos3.z).setColor(color.r * colmod, color.g * colmod, color.b * colmod, color.a * fadeOutP);
        vertex.addVertex((float)center.x, (float)center.y, (float)center.z).setColor(color.r * colmod, color.g * colmod, color.b * colmod, color.a * fadeOutP);
        vertex.addVertex((float)pos.x, (float)pos.y + 0.005f, (float)pos.z).setColor(color.r, color.g, color.b, color.a * fadeOutP);
        vertex.addVertex((float)pos2p.x, (float)pos.y + 0.005f, (float)pos2p.z).setColor(color.r, color.g, color.b, color.a * fadeOutP);
        vertex.addVertex((float)centerp.x, (float)pos.y + 0.005f, (float)centerp.z).setColor(color.r, color.g, color.b, color.a * fadeOutP);
        vertex.addVertex((float)pos.x, (float)pos.y + 0.005f, (float)pos.z).setColor(color.r, color.g, color.b, color.a * fadeOutP);
        vertex.addVertex((float)pos3p.x, (float)pos.y + 0.005f, (float)pos3p.z).setColor(color.r, color.g, color.b, color.a * fadeOutP);
        vertex.addVertex((float)centerp.x, (float)pos.y + 0.005f, (float)centerp.z).setColor(color.r, color.g, color.b, color.a * fadeOutP);
    }

    protected int getLightColor(float p_107249_) {
        return 0xF000F0;
    }

    public ParticleRenderType getRenderType() {
        return RENDER_TYPE;
    }

    public AABB getRenderBoundingBox(float partialTicks) {
        return new AABB((double)(-this.options.getLength()), (double)(-this.options.getLength()), (double)(-this.options.getLength()), (double)this.options.getLength(), (double)this.options.getLength(), (double)this.options.getLength()).move(this.x, this.y, this.z);
    }

    public static class Factory
    implements ParticleProvider<ArcAttackPreparationParticleOptions> {
        @Nullable
        public Particle createParticle(ArcAttackPreparationParticleOptions options, ClientLevel level, double px, double py, double pz, double xd, double yd, double zd) {
            return new ArcAttackPreparationParticle(options, level, px, py, pz, xd, yd, zd);
        }
    }
}

