/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.malkuth_boss;

import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.packets.SetClientMalkuthWeaknessAmountPacket;
import com.finderfeed.fdbosses.init.BossDataAttachments;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public class MalkuthWeaknessHandler {
    public static final int MAX = 100;
    public static final int MIN = -100;

    public static int getCurrentWeaknessLevel(Player player) {
        return Math.clamp((long)((Integer)player.getData(BossDataAttachments.MALKUTH_WEAKNESS.get())).intValue(), -100, 100);
    }

    public static void setCurrentWeakness(Player player, int amount) {
        player.setData(BossDataAttachments.MALKUTH_WEAKNESS.get(), (Object)Math.clamp((long)amount, -100, 100));
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SetClientMalkuthWeaknessAmountPacket(amount), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void damageWeakness(MalkuthAttackType damageType, Player player, int amount) {
        int current = MalkuthWeaknessHandler.getCurrentWeaknessLevel(player);
        if (current >= 0) {
            if (damageType.isIce()) {
                if (current - amount < 0) {
                    MalkuthWeaknessHandler.setCurrentWeakness(player, current - amount * 2);
                } else {
                    MalkuthWeaknessHandler.setCurrentWeakness(player, current - amount);
                }
            } else {
                MalkuthWeaknessHandler.setCurrentWeakness(player, current + amount);
            }
        } else if (damageType.isFire()) {
            if (current + amount >= 0) {
                MalkuthWeaknessHandler.setCurrentWeakness(player, current + amount * 2);
            } else {
                MalkuthWeaknessHandler.setCurrentWeakness(player, current + amount);
            }
        } else {
            MalkuthWeaknessHandler.setCurrentWeakness(player, current - amount);
        }
    }

    public static MalkuthAttackType getWeakTo(Player player) {
        return MalkuthWeaknessHandler.getCurrentWeaknessLevel(player) >= 0 ? MalkuthAttackType.FIRE : MalkuthAttackType.ICE;
    }

    public static boolean isWeakTo(Player player, MalkuthAttackType malkuthAttackType) {
        return MalkuthWeaknessHandler.getWeakTo(player).equals((Object)malkuthAttackType);
    }
}

