/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_cannon;

import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.client.particles.smoke_particle.BigSmokeParticleOptions;
import com.finderfeed.fdbosses.content.entities.IEffectImmune;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthEntity;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthWeaknessHandler;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_cannon.MalkuthCannonProjectile;
import com.finderfeed.fdbosses.init.BossAnims;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossEntityDataSerializers;
import com.finderfeed.fdbosses.init.BossModels;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.FDTagHelper;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.FDLivingEntity;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import com.finderfeed.fdlib.systems.shake.PositionedScreenShakePacket;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class MalkuthCannonEntity
extends FDLivingEntity
implements AutoSerializable,
IEffectImmune {
    private static FDModel CLIENT_MODEL;
    public static final EntityDataAccessor<MalkuthAttackType> MALKUTH_ATTACK_TYPE;
    public static final EntityDataAccessor<Boolean> PLAYER_CONTROLLED;
    public static final EntityDataAccessor<Boolean> BROKEN;
    public static final EntityDataAccessor<Boolean> BROKEN_REQUIRES_MATERIALS;
    private List<Vec3> shootTargets = new ArrayList<Vec3>();
    @SerializableField
    private MalkuthAttackType malkuthCannonType = MalkuthAttackType.ICE;
    @SerializableField
    private int shootTickCount = 0;
    @SerializableField
    private float damage;

    public MalkuthCannonEntity(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
        this.setNoGravity(true);
        this.getAnimationSystem().startAnimation("SUMMON", AnimationTicker.builder(BossAnims.MALKUTH_CANNON_SUMMON).setSpeed(0.75f).build());
        if (level.isClientSide) {
            CLIENT_MODEL = new FDModel(BossModels.MALKUTH_CANNON.get());
        }
    }

    public static MalkuthCannonEntity summon(Level level, Vec3 pos, Vec3 lookAt, MalkuthAttackType malkuthAttackType) {
        MalkuthCannonEntity malkuthCannonEntity = new MalkuthCannonEntity(BossEntities.MALKUTH_CANNON.get(), level);
        malkuthCannonEntity.setPos(pos);
        malkuthCannonEntity.setCannonType(malkuthAttackType);
        malkuthCannonEntity.lookAt(EntityAnchorArgument.Anchor.FEET, lookAt);
        level.addFreshEntity((Entity)malkuthCannonEntity);
        return malkuthCannonEntity;
    }

    public void shoot(List<Vec3> targets, float damage) {
        if (this.level().isClientSide) {
            return;
        }
        if (this.shootTargets.isEmpty()) {
            this.shootTargets = new ArrayList<Vec3>(targets);
            this.damage = damage;
            this.shootTickCount = 20;
        }
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        if (!this.level().isClientSide && hand == InteractionHand.MAIN_HAND && this.isPlayerControlled() && MalkuthWeaknessHandler.isWeakTo(player, this.getCannonType())) {
            if (this.isBroken()) {
                return InteractionResult.SUCCESS;
            }
            MalkuthAttackType attackType = this.getCannonType();
            if (attackType.isFire()) {
                Vec3 fireOffset = new Vec3(6.5, 14.0, 55.0);
                this.shoot(List.of(fireOffset.add(this.position())), 1.0f);
            } else {
                Vec3 iceOffset = new Vec3(-6.5, 14.0, 55.0);
                this.shoot(List.of(iceOffset.add(this.position())), 1.0f);
            }
            player.swing(hand);
        }
        return super.interactAt(player, vec, hand);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (!this.shootTargets.isEmpty()) {
                if (this.shootTickCount == 20) {
                    this.getAnimationSystem().startAnimation("SHOOT", AnimationTicker.builder(BossAnims.MALKUTH_CANNON_SHOOT).build());
                } else if (this.shootTickCount == 16) {
                    Vec3 frwd = this.getForward().multiply(1.0, 0.0, 1.0).normalize();
                    Vec3 summonPos = this.position().add(frwd.x * 1.2, 1.75, frwd.z * 1.2);
                    BossUtil.malkuthCannonShoot((ServerLevel)this.level(), this.malkuthCannonType, summonPos, frwd.add(0.0, (double)0.6f, 0.0), 100.0);
                    for (Vec3 target : this.shootTargets) {
                        Vec3 speed = BossUtil.calculateMortarProjectileVelocity(summonPos, target, -0.08f, 35 + this.random.nextInt(10));
                        MalkuthCannonProjectile.summon(this.level(), summonPos, speed, 1000, this.malkuthCannonType, this.damage);
                    }
                    ((ServerLevel)this.level()).playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_CANNON_SHOOT.get(), SoundSource.HOSTILE, 4.0f, 0.75f);
                    PositionedScreenShakePacket.send((ServerLevel)((ServerLevel)this.level()), (FDShakeData)FDShakeData.builder().frequency(50.0f).amplitude(1.5f).inTime(0).stayTime(0).outTime(10).build(), (Vec3)this.position().add(this.getForward().multiply(1.0, 0.0, 1.0).normalize().add(0.0, 1.0, 0.0)), (double)60.0);
                } else if (this.shootTickCount == 5) {
                    if (this.isPlayerControlled()) {
                        this.setBroken(true);
                    }
                } else if (this.shootTickCount <= 0) {
                    this.shootTargets.clear();
                }
                --this.shootTickCount;
            }
        } else {
            this.brokenRequiresMaterialsParticles();
            this.brokenParticles();
        }
    }

    public void cancelShot() {
        this.getAnimationSystem().stopAnimation("SHOOT");
        this.shootTargets.clear();
        this.shootTickCount = 0;
        this.damage = 0.0f;
    }

    private void brokenRequiresMaterialsParticles() {
        if (!this.requiresRepair()) {
            return;
        }
        Vec3 pos = this.position();
        float t = (float)Math.sin((float)this.tickCount / 30.0f);
        float h = t * 0.125f;
        Vec3 basePPos = pos.add(0.0, (double)(4.0f + h), 0.0);
        for (int i = 0; i < 2; ++i) {
            Vector3f col = MalkuthEntity.getAndRandomizeColor(this.getCannonType(), this.level().random);
            BallParticleOptions ballParticleOptions = BallParticleOptions.builder().color(col.x, col.y, col.z).scalingOptions(0, 0, 20).size(0.025f).brightness(2).build();
            Vec3 fwd = this.getForward().multiply(1.0, 0.0, 1.0).normalize();
            this.level().addParticle((ParticleOptions)ballParticleOptions, basePPos.x + (double)(this.random.nextFloat() * 0.25f) - 0.125 - fwd.x * (double)0.05f, basePPos.y + (double)(this.random.nextFloat() * 0.25f) - 0.125, basePPos.z + (double)(this.random.nextFloat() * 0.25f) - 0.125 - fwd.z * (double)0.05f, 0.0, -0.05, 0.0);
        }
    }

    private void brokenParticles() {
        if (this.level().getGameTime() % 10L == 0L && this.isBroken()) {
            Matrix4f t = this.getModelPartTransformation((Entity)this, "cannon2", CLIENT_MODEL);
            Vector3f position = t.transformPosition(0.0f, 0.0f, -1.25f, new Vector3f()).add((float)this.getX(), (float)this.getY(), (float)this.getZ());
            float r = this.random.nextFloat() * 0.2f + 0.2f;
            BigSmokeParticleOptions options = BigSmokeParticleOptions.builder().color(r, r, r).size(1.0f).lifetime(0, 0, 60).build();
            this.level().addParticle((ParticleOptions)options, (double)position.x, (double)position.y, (double)position.z, 0.0, (double)0.05f, 0.0);
            this.level().addParticle((ParticleOptions)options, (double)position.x, (double)position.y, (double)position.z, 0.0, (double)0.05f, 0.0);
        }
    }

    public void setBrokenRequiresMaterials(boolean broken) {
        if (broken) {
            if (!this.isBroken()) {
                this.getAnimationSystem().startAnimation("BROKE", AnimationTicker.builder(BossAnims.MALKUTH_CANNON_BREAK).build());
            }
            this.entityData.set(BROKEN, (Object)false);
            this.entityData.set(BROKEN_REQUIRES_MATERIALS, (Object)true);
        } else if (this.requiresRepair()) {
            if (this.isBroken()) {
                this.getAnimationSystem().startAnimation("BROKE", AnimationTicker.builder(BossAnims.MALKUTH_CANNON_REPAIR).build());
            }
            this.entityData.set(BROKEN_REQUIRES_MATERIALS, (Object)false);
        }
    }

    public void repairWithMaterial() {
        this.setBrokenRequiresMaterials(false);
    }

    public void setBroken(boolean broken) {
        if (!this.requiresRepair()) {
            if (broken) {
                if (!this.isBroken()) {
                    this.getAnimationSystem().startAnimation("BROKE", AnimationTicker.builder(BossAnims.MALKUTH_CANNON_BREAK).build());
                }
            } else if (this.isBroken()) {
                this.getAnimationSystem().startAnimation("BROKE", AnimationTicker.builder(BossAnims.MALKUTH_CANNON_REPAIR).build());
            }
            this.entityData.set(BROKEN, (Object)broken);
        }
    }

    public boolean requiresRepair() {
        return (Boolean)this.entityData.get(BROKEN_REQUIRES_MATERIALS);
    }

    public boolean isBroken() {
        return (Boolean)this.entityData.get(BROKEN) != false || (Boolean)this.entityData.get(BROKEN_REQUIRES_MATERIALS) != false;
    }

    public boolean isPlayerControlled() {
        return (Boolean)this.entityData.get(PLAYER_CONTROLLED);
    }

    public void setPlayerControlled(boolean controlled) {
        this.entityData.set(PLAYER_CONTROLLED, (Object)controlled);
    }

    private void setCannonType(MalkuthAttackType malkuthAttackType) {
        this.entityData.set(MALKUTH_ATTACK_TYPE, (Object)malkuthAttackType);
        this.malkuthCannonType = malkuthAttackType;
    }

    public MalkuthAttackType getCannonType() {
        return (MalkuthAttackType)((Object)this.entityData.get(MALKUTH_ATTACK_TYPE));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MALKUTH_ATTACK_TYPE, (Object)MalkuthAttackType.FIRE);
        builder.define(BROKEN_REQUIRES_MATERIALS, (Object)false);
        builder.define(PLAYER_CONTROLLED, (Object)false);
        builder.define(BROKEN, (Object)false);
    }

    public boolean hurt(DamageSource src, float damage) {
        if (src.is(DamageTypes.FELL_OUT_OF_WORLD) || src.is(DamageTypes.GENERIC_KILL)) {
            return super.hurt(src, damage);
        }
        return false;
    }

    public boolean isNoGravity() {
        return true;
    }

    public void push(Vec3 p_347665_) {
    }

    public void push(Entity p_21294_) {
    }

    public void push(double p_20286_, double p_20287_, double p_20288_) {
    }

    protected void pushEntities() {
    }

    public void setDeltaMovement(Vec3 p_20257_) {
    }

    public void setDeltaMovement(double p_20335_, double p_20336_, double p_20337_) {
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.autoLoad(tag);
        this.shootTargets = FDTagHelper.loadVec3List((CompoundTag)tag, (String)"targets");
        this.entityData.set(BROKEN, (Object)tag.getBoolean("broken"));
        this.entityData.set(BROKEN_REQUIRES_MATERIALS, (Object)tag.getBoolean("broken_materials"));
        this.entityData.set(PLAYER_CONTROLLED, (Object)tag.getBoolean("playerControlled"));
        this.setCannonType(this.malkuthCannonType);
        if (this.isBroken()) {
            this.getAnimationSystem().startAnimation("BROKE", AnimationTicker.builder(BossAnims.MALKUTH_CANNON_BREAK).build());
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        FDTagHelper.saveVec3List((CompoundTag)tag, (String)"targets", this.shootTargets);
        this.autoSave(tag);
        this.setCannonType(this.malkuthCannonType);
        tag.putBoolean("broken", ((Boolean)this.entityData.get(BROKEN)).booleanValue());
        tag.putBoolean("broken_materials", ((Boolean)this.entityData.get(BROKEN_REQUIRES_MATERIALS)).booleanValue());
        tag.putBoolean("playerControlled", ((Boolean)this.entityData.get(PLAYER_CONTROLLED)).booleanValue());
    }

    public boolean shouldRenderAtSqrDistance(double p_19883_) {
        return true;
    }

    static {
        MALKUTH_ATTACK_TYPE = SynchedEntityData.defineId(MalkuthCannonEntity.class, (EntityDataSerializer)((EntityDataSerializer)BossEntityDataSerializers.MALKUTH_ATTACK_TYPE.get()));
        PLAYER_CONTROLLED = SynchedEntityData.defineId(MalkuthCannonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        BROKEN = SynchedEntityData.defineId(MalkuthCannonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        BROKEN_REQUIRES_MATERIALS = SynchedEntityData.defineId(MalkuthCannonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    }
}

