/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.blocks;

import com.finderfeed.fdbosses.content.tile_entities.TrophyBlockEntity;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.FDEntityBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class TrophyBlock
extends FDEntityBlock {
    private Supplier<Animation> idleAnimation;
    private Supplier<Animation> clickAnimation;
    private BlockEntityType.BlockEntitySupplier<?> tileEntitySupplier;

    public TrophyBlock(BlockBehaviour.Properties block, Supplier<Animation> idleAnimation, Supplier<Animation> clickAnimation, BlockEntityType.BlockEntitySupplier<? extends TrophyBlockEntity> tileEntitySupplier) {
        super(block);
        this.idleAnimation = idleAnimation;
        this.clickAnimation = clickAnimation;
        this.tileEntitySupplier = tileEntitySupplier;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH));
    }

    public Supplier<Animation> getIdleAnimation() {
        return this.idleAnimation;
    }

    public Supplier<Animation> getClickAnimation() {
        return this.clickAnimation;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        ServerLevel serverLevel;
        BlockEntity block;
        if (level instanceof ServerLevel && (block = (serverLevel = (ServerLevel)level).getBlockEntity(pos)) instanceof TrophyBlockEntity) {
            TrophyBlockEntity trophy = (TrophyBlockEntity)block;
            trophy.onClick(player);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HorizontalDirectionalBlock.FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockpos, BlockState state) {
        return this.tileEntitySupplier.create(blockpos, state);
    }

    protected RenderShape getRenderShape(BlockState p_60550_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)ctx.getHorizontalDirection());
    }
}

