/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.chesed_sword_buff;

import com.finderfeed.fdbosses.client.particles.rush_particle.RushParticleOptions;
import com.finderfeed.fdbosses.init.BossConfigs;
import com.finderfeed.fdbosses.init.BossEffects;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdlib.FDLibCalls;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.FDProjectile;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import com.finderfeed.fdlib.util.client.particles.lightning_particle.LightningParticleOptions;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.AttributeUtil;

public class FlyingSwordEntity
extends FDProjectile {
    public static int DELAY_UNTIL_LAUNCH = 15;
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.defineId(FlyingSwordEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.defineId(FlyingSwordEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private UUID target = null;
    public double xao;
    public double yao;
    public double zao;

    public FlyingSwordEntity(EntityType<? extends FDProjectile> type, Level level) {
        super(type, level);
    }

    public static FlyingSwordEntity summonAtTarget(LivingEntity owner, LivingEntity target, ItemStack weapon) {
        Level level = owner.level();
        FlyingSwordEntity flyingSwordEntity = new FlyingSwordEntity(BossEntities.FLYING_SWORD.get(), level);
        flyingSwordEntity.setItem(weapon);
        flyingSwordEntity.target = target.getUUID();
        Vec3 targetPos = target.position();
        Vec3 between = targetPos.subtract(owner.position()).multiply(1.0, 0.0, 1.0).normalize();
        float rndDistMod = Mth.clamp((float)(target.getBbWidth() * 3.0f), (float)2.0f, (float)10.0f) + level.random.nextFloat() * 2.0f;
        float rndOffsNum = level.random.nextBoolean() ? 1.0f : -1.0f;
        Vec3 randomOffset = between.multiply((double)rndDistMod, (double)rndDistMod, (double)rndDistMod).yRot(rndOffsNum * (float)Math.PI / 2.0f + -rndOffsNum * (float)Math.PI / 8.0f).add(0.0, 1.5 + (double)(level.random.nextFloat() * 2.0f), 0.0);
        Vec3 resultPos = targetPos.add(randomOffset);
        flyingSwordEntity.setPos(resultPos);
        flyingSwordEntity.setOwner((Entity)owner);
        flyingSwordEntity.setTargetIdForClient(target);
        if (level.addFreshEntity((Entity)flyingSwordEntity)) {
            ((ServerLevel)level).sendParticles((ParticleOptions)BallParticleOptions.builder().size(0.15f).color(0.1f, 0.9f, 1.0f).scalingOptions(2, 0, 5).friction(0.8f).build(), resultPos.x, resultPos.y, resultPos.z, 60, 0.0, 0.0, 0.0, (double)0.1f);
        }
        return flyingSwordEntity;
    }

    public void tick() {
        if (this.tickCount == 1) {
            this.xao = this.getX();
            this.yao = this.getY();
            this.zao = this.getZ();
        }
        super.tick();
        if (!this.level().isClientSide) {
            if (this.tickCount >= 400) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            this.handleTarget();
            if (this.tickCount == DELAY_UNTIL_LAUNCH - 2) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.GHOST_WEAPON_FLY_OUT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f + this.random.nextFloat() * 0.25f);
            }
        } else {
            Entity entity;
            Vec3 center = this.getActualPos();
            if (this.tickCount == DELAY_UNTIL_LAUNCH && (entity = this.level().getEntity(this.getTargetIdForClient())) instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                Vec3 targetPos = this.getTargetPos(target, 0.0f);
                Vec3 b = center.subtract(targetPos).normalize();
                int count = 7;
                for (int i = 0; i < count; ++i) {
                    Vec3 rndOffset = new Vec3((double)(this.random.nextFloat() * 2.0f - 1.0f), (double)(this.random.nextFloat() * 2.0f - 1.0f), (double)(this.random.nextFloat() * 2.0f - 1.0f)).normalize();
                    float bscale = (float)i / (float)(count - 1) * 2.0f;
                    float scale = this.random.nextFloat() * 0.25f;
                    float defaultScale = 0.1f;
                    Vec3 pos = center.add(rndOffset.multiply((double)scale, (double)scale, (double)scale)).add(rndOffset.multiply((double)defaultScale, (double)defaultScale, (double)defaultScale)).add(b.multiply((double)bscale, (double)bscale, (double)bscale));
                    this.level().addParticle((ParticleOptions)new RushParticleOptions(b, new FDColor(0.8f, 1.0f, 1.0f, 1.0f), this.random.nextFloat() * 0.5f + 0.25f, 0.05f + this.random.nextFloat() * 0.025f, 2 + this.random.nextInt(2)), pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
                }
            }
            Vec3 centerO = new Vec3(this.xao, this.yao, this.zao);
            Vec3 b = center.subtract(centerO);
            double dist = Math.min(centerO.distanceTo(center), 10.0);
            float size = 0.125f;
            Vec3 sp = b.normalize().multiply(0.25, 0.25, 0.25);
            float i = 0.0f;
            while ((double)i < dist) {
                double p = (double)i / dist;
                Vec3 ball = new Vec3(FDMathUtil.lerp((double)centerO.x, (double)center.x, (double)p), FDMathUtil.lerp((double)centerO.y, (double)center.y, (double)p), FDMathUtil.lerp((double)centerO.z, (double)center.z, (double)p)).add((double)this.random.nextFloat() * 0.25 - 0.125, (double)this.random.nextFloat() * 0.25 - 0.125, (double)this.random.nextFloat() * 0.25 - 0.125);
                this.level().addParticle((ParticleOptions)BallParticleOptions.builder().size(size).color(0.1f, 0.9f, 1.0f).scalingOptions(2, 0, 10).friction(0.9f).build(), ball.x + (double)this.random.nextFloat() * 0.25 - 0.125, ball.y + (double)this.random.nextFloat() * 0.25 - 0.125, ball.z + (double)this.random.nextFloat() * 0.25 - 0.125, sp.x, sp.y, sp.z);
                if (this.tickCount % 2 == 0) {
                    this.level().addParticle((ParticleOptions)LightningParticleOptions.builder().randomRoll(true).lifetime(2).maxLightningSegments(4).quadSize(0.3f).color(20, 100, 255).build(), ball.x + (double)this.random.nextFloat() * 0.5 - 0.25, ball.y + (double)this.random.nextFloat() * 0.5 - 0.25, ball.z + (double)this.random.nextFloat() * 0.5 - 0.25, sp.x, sp.y, sp.z);
                }
                i += size * 2.0f;
            }
            this.xao = center.x;
            this.yao = center.y;
            this.zao = center.z;
        }
    }

    private Vec3 getActualPos() {
        Vec3 center = this.position().add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0);
        float time = this.tickCount;
        float p = Math.clamp(time / (float)DELAY_UNTIL_LAUNCH, 0.0f, 1.0f);
        float offset = -Mth.sin((float)(p * (float)Math.PI)) * 2.0f;
        int targetId = this.getTargetIdForClient();
        Entity entity = this.level().getEntity(targetId);
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            Vec3 targetPos = this.getTargetPos(target, 0.0f);
            Vec3 between = targetPos.subtract(center).normalize();
            return center.add(between.multiply((double)offset, (double)offset, (double)offset));
        }
        return center;
    }

    public boolean isCurrentlyGlowing() {
        return true;
    }

    public int getTeamColor() {
        return 0x11AAFF;
    }

    private void handleTarget() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            LivingEntity livingTarget;
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = serverLevel.getEntity(this.target);
            if (entity instanceof LivingEntity && (livingTarget = (LivingEntity)entity).isAlive() && (entity = this.getOwner()) instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity;
                this.setTargetIdForClient(livingTarget);
                if ((float)this.tickCount > (float)DELAY_UNTIL_LAUNCH * 0.75f) {
                    Vec3 thisPos = this.position();
                    Vec3 targetPos = this.getTargetPos(livingTarget, 0.0f);
                    Vec3 between = targetPos.subtract(thisPos);
                    float speed = 1.0f;
                    Vec3 deltaMovement = between.normalize().multiply((double)speed, (double)speed, (double)speed);
                    this.setDeltaMovement(deltaMovement);
                    if (this.position().distanceTo(targetPos) <= 0.5) {
                        FDLibCalls.sendParticles((ServerLevel)((ServerLevel)this.level()), (ParticleOptions)BallParticleOptions.builder().size(2.0f).scalingOptions(0, 0, 2).color(150, 230, 255).build(), (Vec3)targetPos, (double)30.0);
                        this.level().playSound(null, targetPos.x, targetPos.y, targetPos.z, BossSounds.FAST_LIGHTNING_STRIKE.get(), SoundSource.HOSTILE, 2.0f, 1.0f + this.random.nextFloat() * 0.5f);
                        this.hurtTarget(owner, livingTarget);
                        this.remove(Entity.RemovalReason.DISCARDED);
                    }
                }
            } else {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public Vec3 getTargetPos(LivingEntity target, float pticks) {
        return target.getPosition(pticks).add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
    }

    public void setTargetIdForClient(LivingEntity target) {
        this.entityData.set(TARGET_ID, (Object)target.getId());
    }

    public int getTargetIdForClient() {
        return (Integer)this.entityData.get(TARGET_ID);
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        super.onHitEntity(hitResult);
    }

    private void hurtTarget(LivingEntity owner, LivingEntity target) {
        AttributeInstance attribute = owner.getAttribute(Attributes.ATTACK_DAMAGE);
        double base = attribute.getBaseValue();
        Multimap map = AttributeUtil.getSortedModifiers((ItemStack)this.getItem(), (EquipmentSlotGroup)EquipmentSlotGroup.MAINHAND);
        if (map.containsKey((Object)Attributes.ATTACK_DAMAGE)) {
            Collection attributes = map.get((Object)Attributes.ATTACK_DAMAGE);
            Map<AttributeModifier.Operation, List<AttributeModifier>> operationAttributes = this.modifierCollectionToOperationMap(attributes);
            for (AttributeModifier mod : operationAttributes.get(AttributeModifier.Operation.ADD_VALUE)) {
                base += mod.amount();
            }
            double damage = base;
            for (AttributeModifier mod : operationAttributes.get(AttributeModifier.Operation.ADD_MULTIPLIED_BASE)) {
                damage += base * mod.amount();
            }
            for (AttributeModifier mod : operationAttributes.get(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)) {
                damage *= 1.0 + mod.amount();
            }
            float dmg = BossConfigs.BOSS_CONFIG.get().itemConfig.lightningStrikeDamagePercent / 100.0f;
            DamageSource damageSource = this.level().damageSources().mobAttack(owner);
            damage = EnchantmentHelper.modifyDamage((ServerLevel)((ServerLevel)this.level()), (ItemStack)this.getItem(), (Entity)target, (DamageSource)damageSource, (float)((float)damage));
            target.setRemainingFireTicks(0);
            target.invulnerableTime = 0;
            if (target.hurt(damageSource, (float)(damage *= (double)dmg))) {
                int duration = BossConfigs.BOSS_CONFIG.get().itemConfig.lightningStrikeShockDuration;
                target.addEffect(new MobEffectInstance(BossEffects.SHOCKED, duration, 0));
                EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)this.level()), (Entity)target, (DamageSource)damageSource);
                target.invulnerableTime = 0;
            }
        }
    }

    private Map<AttributeModifier.Operation, List<AttributeModifier>> modifierCollectionToOperationMap(Collection<AttributeModifier> collection) {
        LinkedHashMap<AttributeModifier.Operation, List<AttributeModifier>> operationListMap = new LinkedHashMap<AttributeModifier.Operation, List<AttributeModifier>>();
        operationListMap.put(AttributeModifier.Operation.ADD_VALUE, new ArrayList());
        operationListMap.put(AttributeModifier.Operation.ADD_MULTIPLIED_BASE, new ArrayList());
        operationListMap.put(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, new ArrayList());
        for (AttributeModifier mod : collection) {
            ((List)operationListMap.get(mod.operation())).add(mod);
        }
        return operationListMap;
    }

    protected void onHitBlock(BlockHitResult hitResult) {
    }

    public ItemStack getItem() {
        return (ItemStack)this.entityData.get(ITEM);
    }

    public void setItem(ItemStack itemStack) {
        this.entityData.set(ITEM, (Object)itemStack);
    }

    protected void defineSynchedData(SynchedEntityData.Builder b) {
        b.define(ITEM, (Object)Items.WOODEN_SWORD.getDefaultInstance());
        b.define(TARGET_ID, (Object)0);
    }

    protected void checkInsideBlocks() {
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("item")) {
            Tag t = tag.get("item");
            Optional opt = ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)t);
            if (opt.isPresent()) {
                this.setItem((ItemStack)opt.get());
            }
        }
        if (tag.contains("target")) {
            this.target = tag.getUUID("target");
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        Tag t = this.getItem().save((HolderLookup.Provider)this.level().registryAccess());
        tag.put("item", t);
        if (this.target != null) {
            tag.putUUID("target", this.target);
        }
    }
}

