/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.projectiles;

import com.finderfeed.fdbosses.content.entities.chesed_boss.ChesedBossBuddy;
import com.finderfeed.fdbosses.content.entities.chesed_boss.earthshatter_entity.EarthShatterEntity;
import com.finderfeed.fdbosses.content.entities.chesed_boss.earthshatter_entity.EarthShatterSettings;
import com.finderfeed.fdbosses.content.entities.chesed_boss.flying_block_entity.FlyingBlockEntity;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdbosses.packets.SlamParticlesPacket;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import com.finderfeed.fdlib.systems.shake.PositionedScreenShakePacket;
import com.finderfeed.fdlib.util.FDProjectile;
import com.finderfeed.fdlib.util.ProjectileMovementPath;
import com.finderfeed.fdlib.util.client.particles.FDBlockParticleOptions;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ChesedBlockProjectile
extends FDProjectile
implements AutoSerializable {
    public static final EntityDataAccessor<Float> ROTATION_SPEED = SynchedEntityData.defineId(ChesedBlockProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<BlockState> STATE = SynchedEntityData.defineId(ChesedBlockProjectile.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    public static final EntityDataAccessor<Boolean> DROP_PARTICLES = SynchedEntityData.defineId(ChesedBlockProjectile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @SerializableField
    private float damage;
    public ProjectileMovementPath movementPath = null;
    private int dropParticlesTime = 0;
    public Quaternionf currentRotation = new Quaternionf(new AxisAngle4f(0.0f, 0.01f, 1.0f, 0.0f));
    public Quaternionf previousRotation = new Quaternionf(new AxisAngle4f(0.0f, 0.01f, 1.0f, 0.0f));

    public ChesedBlockProjectile(EntityType<? extends AbstractHurtingProjectile> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        this.dropParticles();
        if (this.level().isClientSide) {
            this.handleRotation();
        } else {
            if (this.movementPath != null) {
                this.movementPath.tick((Entity)this);
                if (this.movementPath.isFinished()) {
                    this.movementPath.tick((Entity)this);
                    this.movementPath = this.movementPath.getNext();
                }
            }
            if (this.tickCount >= 2000) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private Vec3 targetGroundPosition(LivingEntity target) {
        Vec3 toReturn = target.position();
        BlockPos pos = new BlockPos((int)org.joml.Math.floor((double)toReturn.x), (int)org.joml.Math.floor((double)toReturn.y), (int)org.joml.Math.floor((double)toReturn.z));
        for (int i = 0; i < 5; ++i) {
            if (!this.level().getBlockState(pos.offset(0, -i, 0)).isAir()) {
                return toReturn;
            }
            toReturn = toReturn.subtract(0.0, 1.0, 0.0);
        }
        return toReturn;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    private void dropParticles() {
        if (this.level().isClientSide) {
            if (!((Boolean)this.entityData.get(DROP_PARTICLES)).booleanValue()) {
                return;
            }
            FDBlockParticleOptions options = FDBlockParticleOptions.builder().state(this.getBlockState()).lifetime(20 + this.random.nextInt(5)).quadSizeMultiplier(1.5f).build();
            this.level().addParticle((ParticleOptions)options, true, this.getX() + (double)this.random.nextFloat() - 0.5, this.getY() + (double)(this.random.nextFloat() * 0.5f), this.getZ() + (double)this.random.nextFloat() - 0.5, 0.0, -0.05 + (double)(this.random.nextFloat() * 0.025f), 0.0);
        } else {
            this.dropParticlesTime = Mth.clamp((int)(this.dropParticlesTime - 1), (int)0, (int)Integer.MAX_VALUE);
            this.entityData.set(DROP_PARTICLES, (Object)(this.dropParticlesTime > 0 ? 1 : 0));
        }
    }

    private void handleRotation() {
        Vec3 oldPos = new Vec3(this.xo, this.yo, this.zo);
        Vec3 currentPos = this.position();
        Vec3 b = currentPos.subtract(oldPos).add(0.01, 0.0, 0.01);
        double len = b.length();
        if (len > 0.01) {
            Vector3f v = this.currentRotation.transform(0.0f, 1.0f, 0.0f, new Vector3f());
            Vec3 v3 = FDMathUtil.vector3fToVec3((Vector3f)v);
            float currentAngleBetween = (float)FDMathUtil.angleBetweenVectors((Vec3)b, (Vec3)v3);
            Vec3 axis = b.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
            this.previousRotation = new Quaternionf((Quaternionfc)this.currentRotation);
            if ((double)currentAngleBetween > 0.1) {
                float bt = (float)FDMathUtil.angleBetweenVectors((Vec3)b, (Vec3)new Vec3(0.0, 1.0, 0.0));
                Quaternionf targetQuaternion = new Quaternionf(new AxisAngle4f(-bt, (float)axis.x, (float)axis.y, (float)axis.z));
                float rot = (float)Math.toRadians((double)this.getRotationSpeed() * len);
                this.currentRotation.slerp((Quaternionfc)targetQuaternion, Mth.clamp((float)(rot / currentAngleBetween), (float)0.0f, (float)1.0f));
            }
        }
    }

    public float getRotationSpeed() {
        return ((Float)this.entityData.get(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float rotationSpeed) {
        this.entityData.set(ROTATION_SPEED, (Object)Float.valueOf(rotationSpeed));
    }

    public BlockState getBlockState() {
        return (BlockState)this.entityData.get(STATE);
    }

    public void setBlockState(BlockState state) {
        this.entityData.set(STATE, (Object)state);
    }

    public void setDropParticlesTime(int dropParticlesTime) {
        this.dropParticlesTime = dropParticlesTime;
    }

    public int getDropParticlesTime() {
        return this.dropParticlesTime;
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (!this.level().isClientSide && !this.noPhysics) {
            this.damageEntities(blockHitResult.getLocation(), 7.0f);
            SlamParticlesPacket packet = new SlamParticlesPacket(new SlamParticlesPacket.SlamData(blockHitResult.getBlockPos(), blockHitResult.getLocation(), this.getDeltaMovement()));
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            PositionedScreenShakePacket.send((ServerLevel)((ServerLevel)this.level()), (FDShakeData)FDShakeData.builder().frequency(1.5f).stayTime(0).inTime(2).outTime(6).amplitude(15.0f).build(), (Vec3)blockHitResult.getLocation().add(this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().multiply(2.0, 2.0, 2.0)), (double)5.0);
            this.shatter(blockHitResult, 0.5235988f);
            this.launchBlocks(blockHitResult, 0.5235988f);
            this.remove(Entity.RemovalReason.DISCARDED);
            this.level().playSound(null, this.position().x, this.position().y, this.position().z, BossSounds.ROCK_IMPACT.get(), SoundSource.HOSTILE, 0.75f, 1.0f);
        }
    }

    private void damageEntities(Vec3 pos, float radius) {
        AABB box = new AABB((double)(-radius), -1.0, (double)(-radius), (double)radius, 4.0, (double)radius);
        Vec3 movement = this.getDeltaMovement().normalize();
        Vec3 pos2 = pos.add(movement.reverse());
        List list = this.level().getEntitiesOfClass(LivingEntity.class, box.move(pos2.add(movement)), entity -> !(entity instanceof ChesedBossBuddy) && entity.position().multiply(1.0, 0.0, 1.0).distanceTo(pos2.multiply(1.0, 0.0, 1.0)) <= (double)radius);
        for (LivingEntity entity2 : list) {
            Vec3 b = entity2.position().subtract(pos2).normalize();
            Vec3 forwardVec = movement.multiply(1.0, 0.0, 1.0).normalize();
            double angle = Math.toDegrees(FDMathUtil.angleBetweenVectors((Vec3)b.multiply(1.0, 0.0, 1.0), (Vec3)forwardVec));
            if (!(angle < 25.0)) continue;
            entity2.hurt(BossDamageSources.CHESED_BLOCK_ATTACK_SOURCE, this.damage);
            entity2.invulnerableTime = 0;
        }
    }

    private void shatter(BlockHitResult result, float rotationLimit) {
        Vec3 direction = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize();
        BlockPos hitPos = result.getBlockPos();
        int maxDist = 7;
        Vec3 hitCenter = hitPos.getCenter();
        for (int x = -maxDist; x <= maxDist; ++x) {
            for (int z = -maxDist; z <= maxDist; ++z) {
                double diff;
                BlockPos p = hitPos.offset(x, 0, z);
                Vec3 center = p.getCenter();
                Vec3 b = center.subtract(hitCenter).multiply(1.0, 0.0, 1.0);
                double len = b.length();
                if (len > (double)maxDist || !((diff = FDMathUtil.angleBetweenVectors((Vec3)direction, (Vec3)b)) <= (double)rotationLimit)) continue;
                EarthShatterEntity earthShatterEntity = EarthShatterEntity.summon(this.level(), p, EarthShatterSettings.builder().direction(b.normalize().reverse().add(0.0, 0.5, 0.0)).delay((int)Math.round(b.length())).upDistance(0.1f + (float)b.length() / (float)maxDist).upTime(1).stayTime(2).downTime(3).build());
            }
        }
    }

    private void launchBlocks(BlockHitResult blockHitResult, float rotationLimit) {
        float baseSpeed = 2.4f;
        Vec3 base = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().multiply((double)baseSpeed, 0.0, (double)baseSpeed);
        int count = 3 + this.random.nextInt(3);
        Vec3 center = blockHitResult.getBlockPos().getCenter().add(0.0, 0.5, 0.0);
        List<BlockState> states = this.collectStates(blockHitResult.getBlockPos(), 2);
        float angle = rotationLimit * 2.0f / (float)count;
        for (int i = 0; i <= count; ++i) {
            float ang = (float)i * angle - rotationLimit + this.random.nextFloat() * (angle / 2.0f) - angle / 4.0f;
            float md = 1.0f - Math.abs(ang) / rotationLimit;
            float randY = this.random.nextFloat() * 0.05f * md + 0.32f;
            float speedMd = 1.0f + (this.random.nextFloat() * 0.25f + md * 0.75f);
            Vec3 f = base.multiply((double)speedMd, 0.0, (double)speedMd).yRot(ang).add(0.0, (double)randY, 0.0);
            BlockState state = states.get(this.random.nextInt(states.size()));
            FlyingBlockEntity blockEntity = new FlyingBlockEntity(BossEntities.FLYING_BLOCK.get(), this.level());
            blockEntity.setAirFriction(0.7f);
            blockEntity.setPos(center);
            blockEntity.setNoPhysicsTime(2);
            blockEntity.setBlockState(state);
            blockEntity.setRotationSpeed((float)f.length() / 2.0f * 15.0f);
            blockEntity.setDeltaMovement(f);
            this.level().addFreshEntity((Entity)blockEntity);
            int g = 0;
            while ((float)g < md * 2.0f) {
                float mod = 0.6f + this.random.nextFloat() * 0.4f - 0.2f;
                f = base.multiply((double)speedMd, 0.0, (double)speedMd).yRot(ang + this.random.nextFloat() * (angle / 2.0f) - angle / 4.0f).add(0.0, (double)randY, 0.0).multiply((double)mod, (double)mod, (double)mod);
                blockEntity = new FlyingBlockEntity(BossEntities.FLYING_BLOCK.get(), this.level());
                blockEntity.setAirFriction(0.72f);
                blockEntity.setPos(center);
                blockEntity.setNoPhysicsTime(2);
                blockEntity.setBlockState(state);
                blockEntity.setRotationSpeed((float)f.length() / 2.0f * 15.0f);
                blockEntity.setDeltaMovement(f);
                this.level().addFreshEntity((Entity)blockEntity);
                ++g;
            }
        }
    }

    private List<BlockState> collectStates(BlockPos baseImpactPos, int blockRadius) {
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        for (int x = -blockRadius; x <= blockRadius; ++x) {
            for (int y = -blockRadius; y <= blockRadius; ++y) {
                for (int z = -blockRadius; z <= blockRadius; ++z) {
                    BlockPos takePos = baseImpactPos.offset(x, y, z);
                    BlockState state = this.level().getBlockState(takePos);
                    if (state.isAir() || states.contains(state)) continue;
                    states.add(state);
                }
            }
        }
        return states;
    }

    public void lerpTo(double x, double y, double z, float p_19899_, float p_19900_, int p_19901_) {
        super.lerpTo(x, y, z, p_19899_, p_19900_, p_19901_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ROTATION_SPEED, (Object)Float.valueOf(20.0f)).define(STATE, (Object)Blocks.DEEPSLATE.defaultBlockState()).define(DROP_PARTICLES, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.movementPath != null) {
            this.movementPath.autoSave("path", tag);
        }
        tag.putFloat("rotationSpeed", this.getRotationSpeed());
        tag.put("state", (Tag)NbtUtils.writeBlockState((BlockState)this.getBlockState()));
        this.autoSave(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("path")) {
            this.movementPath = new ProjectileMovementPath();
            this.movementPath.autoLoad("path", tag);
        }
        this.setRotationSpeed(tag.getFloat("rotationSpeed"));
        this.setBlockState(NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)tag.getCompound("state")));
        this.autoLoad(tag);
    }
}

