/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.projectiles;

import com.finderfeed.fdbosses.BossTargetFinder;
import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.client.BossParticles;
import com.finderfeed.fdbosses.client.particles.GravityParticleOptions;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthEntity;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_crush.MalkuthCrushAttack;
import com.finderfeed.fdbosses.init.BossConfigs;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossEntityDataSerializers;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import com.finderfeed.fdlib.systems.shake.PositionedScreenShakePacket;
import com.finderfeed.fdlib.util.FDProjectile;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class MalkuthPlayerFireIceBall
extends FDProjectile
implements AutoSerializable {
    public static final EntityDataAccessor<MalkuthAttackType> ATTACK_TYPE = SynchedEntityData.defineId(MalkuthPlayerFireIceBall.class, (EntityDataSerializer)((EntityDataSerializer)BossEntityDataSerializers.MALKUTH_ATTACK_TYPE.get()));
    private ItemStack itemStack;

    public static MalkuthPlayerFireIceBall summon(LivingEntity owner, Vec3 pos, Vec3 speed, MalkuthAttackType attackType, ItemStack tool) {
        MalkuthPlayerFireIceBall malkuthPlayerFireIceBall = new MalkuthPlayerFireIceBall(BossEntities.MALKUTH_PLAYER_FIREBALL.get(), owner.level());
        malkuthPlayerFireIceBall.setOwner((Entity)owner);
        malkuthPlayerFireIceBall.setPos(pos);
        malkuthPlayerFireIceBall.setDeltaMovement(speed);
        malkuthPlayerFireIceBall.setAttackType(attackType);
        malkuthPlayerFireIceBall.itemStack = tool;
        owner.level().playSound(null, pos.x, pos.y, pos.z, BossSounds.MALKUTH_FIREBALL_LAUNCH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        owner.level().addFreshEntity((Entity)malkuthPlayerFireIceBall);
        return malkuthPlayerFireIceBall;
    }

    public MalkuthPlayerFireIceBall(EntityType<? extends AbstractHurtingProjectile> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.tickCount > 1000 || this.itemStack == null || this.itemStack.isEmpty()) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        } else {
            this.particles();
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        LivingEntity livingEntity;
        Entity entity;
        super.onHitEntity(result);
        if (!this.level().isClientSide && (entity = result.getEntity()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity) != this.getOwner()) {
            Vec3 location = result.getLocation();
            Direction direction = null;
            if (Math.abs(location.y - livingEntity.getY()) < 3.0 && livingEntity.onGround()) {
                location = new Vec3(location.x, livingEntity.getY(), location.z);
                direction = Direction.UP;
            }
            this.explode(location, direction);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide) {
            Direction direction = result.getDirection();
            this.explode(result.getLocation(), direction);
        }
    }

    public void explode(Vec3 pos, Direction crushDirectionOrNoCrush) {
        if (this.getAttackType().isIce()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_ICE_FIREBALL_EXPLOSION.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
        } else {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_FIREBALL_EXPLOSION.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
        }
        BossUtil.malkuthPlayerFireballExplosionParticles((ServerLevel)this.level(), pos, this.getAttackType());
        PositionedScreenShakePacket.send((ServerLevel)((ServerLevel)this.level()), (FDShakeData)FDShakeData.builder().frequency(50.0f).amplitude(1.5f).inTime(0).stayTime(0).outTime(10).build(), (Vec3)pos, (double)40.0);
        this.remove(Entity.RemovalReason.DISCARDED);
        if (crushDirectionOrNoCrush != null) {
            MalkuthCrushAttack.summon(this.level(), pos, 0.0f, crushDirectionOrNoCrush, this.getAttackType());
            this.level().playSound(null, pos.x, pos.y, pos.z, BossSounds.ROCK_IMPACT.get(), SoundSource.PLAYERS, 3.0f, 0.8f);
            this.level().playSound(null, pos.x, pos.y, pos.z, BossSounds.MALKUTH_SWORD_EARTH_IMPACT.get(), SoundSource.PLAYERS, 3.0f, 0.8f);
        }
        DamageSource damageSource = this.level().damageSources().generic();
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            damageSource = this.level().damageSources().mobAttack(livingEntity);
        }
        float dmgModifier = BossConfigs.BOSS_CONFIG.get().itemConfig.playerMalkuthFireballToolDamagePercent / 100.0f;
        for (LivingEntity target : BossTargetFinder.getEntitiesInSphere(LivingEntity.class, this.level(), pos, 3.0f)) {
            double damage = 5.0;
            if (target == this.getOwner()) continue;
            Entity entity2 = this.getOwner();
            if (entity2 instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity2;
                damage = BossUtil.getToolDamage(livingEntity, (Entity)target, this.itemStack) * (double)dmgModifier;
            }
            if (this.getAttackType().isFire()) {
                target.setRemainingFireTicks(200);
            } else {
                target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 2));
            }
            target.hurt(damageSource, (float)damage);
        }
    }

    private void particles() {
        Vec3 between = new Vec3(this.getX() - this.xo, this.getY() - this.yo, this.getZ() - this.zo);
        double length = between.length();
        Vec3 pos = this.position().add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0);
        float maxrad = 0.5f;
        float g = -0.001f;
        while ((double)g < length * (double)0.8f) {
            for (int i = 0; i < 10; ++i) {
                Vector3f color = MalkuthEntity.getAndRandomizeColor(this.getAttackType(), this.random);
                Object particleOptions = this.random.nextFloat() > 0.1f ? BallParticleOptions.builder().color(color.x, color.y, color.z).scalingOptions(0, 0, 4 + this.random.nextInt(4)).brightness(1).build() : (this.getAttackType().isFire() ? ParticleTypes.FLAME : new GravityParticleOptions(BossParticles.ICE_CHUNK.get(), 5 + this.random.nextInt(4), 0.5f + this.random.nextFloat() * 0.2f, 0.0f, 2.0f, true));
                float rndOut = maxrad / 2.0f + this.random.nextFloat() * maxrad / 2.0f;
                Vec3 rndOffs = new Vec3((double)(this.random.nextFloat() * 2.0f - 1.0f), (double)(this.random.nextFloat() * 2.0f - 1.0f), (double)(this.random.nextFloat() * 2.0f - 1.0f)).normalize().multiply((double)rndOut, (double)rndOut, (double)rndOut);
                Vec3 distOffset = between.normalize().multiply((double)g, (double)g, (double)g);
                Vec3 ppos = pos.add(rndOffs).subtract(distOffset);
                float vspeed = length == 0.0 ? -this.random.nextFloat() * 0.1f : 0.0f;
                this.level().addParticle((ParticleOptions)particleOptions, true, ppos.x, ppos.y, ppos.z, 0.0, (double)vspeed, 0.0);
            }
            g += maxrad;
        }
    }

    public boolean isPickable() {
        return true;
    }

    public MalkuthAttackType getAttackType() {
        return (MalkuthAttackType)((Object)this.entityData.get(ATTACK_TYPE));
    }

    public void setAttackType(MalkuthAttackType type) {
        this.entityData.set(ATTACK_TYPE, (Object)type);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACK_TYPE, (Object)MalkuthAttackType.ICE);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("item", this.itemStack.save((HolderLookup.Provider)this.level().registryAccess()));
        tag.putString("mtype", ((MalkuthAttackType)((Object)this.entityData.get(ATTACK_TYPE))).name());
        this.autoSave(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("mtype")) {
            this.entityData.set(ATTACK_TYPE, (Object)MalkuthAttackType.valueOf(tag.getString("mtype")));
        }
        if (tag.contains("item")) {
            this.itemStack = (ItemStack)ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)tag.getCompound("item")).get();
        }
        this.autoLoad(tag);
    }
}

