/*
 * Decompiled with CFR 0.152.
 */
package itzazeem.axeat;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Axeat
extends JavaPlugin
implements Listener {
    private final Set<Player> activePlayers = new HashSet<Player>();

    public void onEnable() {
        this.getLogger().info("AxEat Auto-Eat Plugin Enabled!");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        new BukkitRunnable(){

            public void run() {
                for (Player player : Axeat.this.activePlayers) {
                    Axeat.this.autoEat(player);
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    public void onDisable() {
        this.getLogger().info("AxEat Auto-Eat Plugin Disabled!");
        this.activePlayers.clear();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.activePlayers.add(event.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.activePlayers.remove(event.getPlayer());
    }

    private void autoEat(Player player) {
        if (player.getFoodLevel() >= 20) {
            return;
        }
        int needed = 20 - player.getFoodLevel();
        for (ItemStack item : player.getInventory().getContents()) {
            Material type;
            if (item == null || !(type = item.getType()).isEdible()) continue;
            int foodValue = this.getFoodValue(type);
            int toEat = Math.min(needed, foodValue);
            player.setFoodLevel(player.getFoodLevel() + toEat);
            needed -= toEat;
            item.setAmount(item.getAmount() - 1);
            if (item.getAmount() <= 0) {
                player.getInventory().remove(item);
            }
            if (needed <= 0) break;
        }
    }

    private int getFoodValue(Material material) {
        switch (material) {
            case APPLE: {
                return 4;
            }
            case BREAD: {
                return 5;
            }
            case COOKED_BEEF: {
                return 8;
            }
            case COOKED_CHICKEN: {
                return 6;
            }
            case COOKED_PORKCHOP: {
                return 8;
            }
            case COOKED_MUTTON: {
                return 6;
            }
            case COOKED_RABBIT: {
                return 5;
            }
            case COOKED_COD: {
                return 5;
            }
            case COOKED_SALMON: {
                return 6;
            }
            case CARROT: {
                return 3;
            }
            case BAKED_POTATO: {
                return 5;
            }
            case PUMPKIN_PIE: {
                return 8;
            }
            case MELON_SLICE: {
                return 2;
            }
        }
        return 4;
    }
}

