/*
 * Decompiled with CFR 0.152.
 */
package com.craftmend.storm;

import com.craftmend.storm.StormOptions;
import com.craftmend.storm.api.StormModel;
import com.craftmend.storm.api.builders.QueryBuilder;
import com.craftmend.storm.connection.StormDriver;
import com.craftmend.storm.gson.InstantTypeAdapter;
import com.craftmend.storm.logger.StormLogger;
import com.craftmend.storm.parser.ModelParser;
import com.craftmend.storm.parser.objects.ParsedField;
import com.craftmend.storm.utils.ColumnDefinition;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class Storm {
    private StormLogger logger;
    private final Map<Class<? extends StormModel>, ModelParser<? extends StormModel>> registeredModels = new HashMap<Class<? extends StormModel>, ModelParser<? extends StormModel>>();
    private final StormDriver driver;
    private boolean createdTables = false;
    private Gson gson;

    public Storm(StormOptions options, StormDriver driver) {
        this.logger = options.getLogger();
        this.driver = driver;
        GsonBuilder gb = new GsonBuilder();
        for (Map.Entry<Class<?>, Object> entry : options.getTypeAdapters().entrySet()) {
            Class<?> t = entry.getKey();
            Object a = entry.getValue();
            gb.registerTypeAdapter(t, a);
        }
        gb.registerTypeAdapter((Type)((Object)Instant.class), new InstantTypeAdapter());
        this.gson = gb.create();
    }

    public Storm(StormDriver driver) {
        this(new StormOptions(), driver);
    }

    public void registerModel(StormModel model) throws SQLException {
        if (this.registeredModels.containsKey(model.getClass())) {
            return;
        }
        ModelParser<StormModel> parsed = new ModelParser<StormModel>(model.getClass(), this, model);
        this.logger.info("Registering class <-> table (" + parsed.getTableName() + "<->" + model.getClass().getSimpleName() + ".java)");
        this.registeredModels.put(model.getClass(), parsed);
    }

    public void runMigrations() throws SQLException {
        for (Map.Entry<Class<? extends StormModel>, ModelParser<? extends StormModel>> entry : this.registeredModels.entrySet()) {
            ModelParser<? extends StormModel> parsed = entry.getValue();
            StormModel model = parsed.getEmptyInstance();
            if (parsed.isMigrated()) continue;
            try (ResultSet tables = this.driver.getMeta().getTables(null, null, parsed.getTableName(), null);){
                if (!tables.next()) {
                    this.logger.info("Creating table " + parsed.getTableName() + "...");
                    this.driver.execute(model.statements().buildSqlTableCreateStatement(this.driver.getDialect(), this));
                }
            }
            HashMap<String, ParsedField[]> columnsInDatabase = new HashMap<String, ParsedField[]>();
            try (ResultSet tables = this.driver.getMeta().getColumns(null, null, parsed.getTableName(), null);){
                while (tables.next()) {
                    ParsedField[] type = tables.getString("TYPE_NAME");
                    String name = tables.getString("COLUMN_NAME");
                    columnsInDatabase.put(name, type);
                }
            }
            ArrayList<String> missingInDatabase = new ArrayList<String>();
            for (ParsedField parsedField : parsed.getParsedFields()) {
                missingInDatabase.add(parsedField.getColumnName());
            }
            missingInDatabase.removeAll(columnsInDatabase.keySet());
            ArrayList missingInLocal = new ArrayList();
            missingInLocal.addAll(columnsInDatabase.keySet());
            for (ParsedField parsedField : parsed.getParsedFields()) {
                missingInLocal.remove(parsedField.getColumnName());
            }
            for (String columnName : missingInLocal) {
                this.logger.warning("Dropping column '" + columnName + "' because it's not present in the local class");
                this.driver.executeUpdate("ALTER TABLE %table DROP COLUMN %column;".replace("%table", parsed.getTableName()).replace("%column", columnName), new Object[0]);
            }
            for (String columnName : missingInDatabase) {
                for (ParsedField parsedField : parsed.getParsedFields()) {
                    if (!parsedField.getColumnName().equals(columnName)) continue;
                    this.logger.warning("Column '" + columnName + "' is not present in the remote table schema. Altering table and adding type " + this.driver.getDialect().compileColumn(parsedField));
                    ColumnDefinition cd = this.driver.getDialect().compileColumn(parsedField);
                    String sql = cd.getColumnSql();
                    if (cd.getConfigurationSql() != null) {
                        sql = sql + ", " + cd.getConfigurationSql();
                    }
                    String statement = "ALTER TABLE %table ADD COLUMN %columnData;".replace("%table", parsed.getTableName()).replace("%columnData", sql);
                    this.driver.executeUpdate(statement, new Object[0]);
                }
            }
            parsed.setMigrated(true);
        }
        this.createdTables = true;
    }

    public <T extends StormModel> QueryBuilder<T> buildQuery(Class<T> model) {
        this.catchState();
        ModelParser<? extends StormModel> parser = this.registeredModels.get(model);
        if (parser == null) {
            throw new IllegalArgumentException("The model " + model.getName() + " isn't loaded. Please call storm.migrate() with an empty instance");
        }
        return new QueryBuilder<StormModel>(model, parser, this);
    }

    public <T extends StormModel> CompletableFuture<Integer> count(Class<T> model) throws Exception {
        this.catchState();
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        String query = "SELECT COUNT(*) FROM " + this.getParsedModel(model, true).getTableName() + ";";
        this.driver.executeQuery(query, rows -> {
            boolean found = false;
            while (rows.next()) {
                future.complete(rows.getInt(1));
                found = true;
            }
            if (!found) {
                future.complete(0);
            }
        }, new Object[0]);
        return future;
    }

    public <T extends StormModel> CompletableFuture<Collection<T>> executeQuery(QueryBuilder<T> query) throws Exception {
        this.catchState();
        CompletableFuture future = new CompletableFuture();
        ArrayList results = new ArrayList();
        ModelParser<? extends StormModel> parser = this.registeredModels.get(query.getModel());
        if (parser == null) {
            throw new IllegalArgumentException("The model " + query.getModel().getName() + " isn't loaded. Please call storm.migrate() with an empty instance");
        }
        QueryBuilder.PreparedQuery pq = query.build();
        this.driver.executeQuery(pq.getQuery(), rows -> {
            while (rows.next()) {
                results.add(parser.fromResultSet(rows, parser.getRelationFields()));
            }
            future.complete(results);
        }, pq.getValues());
        return future;
    }

    public <T extends StormModel> CompletableFuture<Collection<T>> findAll(Class<T> model) throws Exception {
        this.catchState();
        CompletableFuture future = new CompletableFuture();
        ArrayList results = new ArrayList();
        ModelParser<? extends StormModel> parser = this.registeredModels.get(model);
        if (parser == null) {
            throw new IllegalArgumentException("The model " + model.getName() + " isn't loaded. Please call storm.migrate() with an empty instance");
        }
        this.driver.executeQuery("select * from " + parser.getTableName(), rows -> {
            while (rows.next()) {
                results.add(parser.fromResultSet(rows, parser.getRelationFields()));
            }
            future.complete(results);
        }, new Object[0]);
        return future;
    }

    public void delete(StormModel model) throws SQLException {
        this.catchState();
        model.preDelete();
        ModelParser<? extends StormModel> parser = this.registeredModels.get(model.getClass());
        if (parser == null) {
            throw new IllegalArgumentException("The model " + model.getClass().getName() + " isn't loaded. Please call storm.migrate() with an empty instance");
        }
        if (model.getId() == null) {
            throw new IllegalArgumentException("This model doesn't have an ID");
        }
        this.driver.executeUpdate("DELETE FROM " + parser.getTableName() + " WHERE id=" + model.getId(), new Object[0]);
        model.postDelete();
    }

    public <T extends StormModel> ModelParser<T> getParsedModel(Class<T> m, boolean loadIfNotFound) {
        ModelParser<? extends StormModel> parser = this.registeredModels.get(m);
        if (parser == null) {
            if (loadIfNotFound) {
                try {
                    StormModel sm = (StormModel)m.getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.registerModel(sm);
                    return this.getParsedModel(m, false);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | SQLException exception) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("The model " + m.getName() + " isn't loaded. Please call storm.migrate() with an empty instance");
        }
        return parser;
    }

    public int save(StormModel model) throws SQLException {
        this.catchState();
        model.preSave();
        String updateOrInsert = "update %tableName set %psUpdateValues where id=%id";
        String insertStatement = "insert into %tableName(%insertVars) values(%insertValues);";
        StringBuilder updateValues = new StringBuilder();
        StringBuilder insertRow = new StringBuilder();
        String insertPointers = "";
        int nonAutoFields = model.parsed(this).getParsedFields().length;
        for (ParsedField parsedField : model.parsed(this).getParsedFields()) {
            if (!parsedField.isAutoIncrement()) continue;
            --nonAutoFields;
        }
        Object[] preparedValues = new Object[nonAutoFields];
        int pvi = 0;
        for (int i = 0; i < model.parsed(this).getParsedFields().length; ++i) {
            boolean notLast = i + 1 != nonAutoFields;
            ParsedField mf = model.parsed(this).getParsedFields()[i];
            if (mf.isAutoIncrement()) continue;
            preparedValues[pvi] = mf.valueOn(model);
            ++pvi;
            updateValues.append(mf.getColumnName() + " = ?");
            if (notLast) {
                updateValues.append(", ");
            }
            insertRow.append(mf.getColumnName());
            insertPointers = insertPointers + "?";
            if (!notLast) continue;
            insertRow.append(", ");
            insertPointers = insertPointers + ", ";
        }
        insertStatement = insertStatement.replace("%insertVars", insertRow.toString()).replace("%insertValues", insertPointers).replaceAll("%tableName", model.parsed(this).getTableName());
        updateOrInsert = updateOrInsert.replace("%psUpdateValues", updateValues.toString()).replaceAll("%tableName", model.parsed(this).getTableName()).replace("%id", model.getId() + "");
        if (model.getId() == null) {
            int o = this.driver.executeUpdate(insertStatement, preparedValues);
            model.setId(o);
            model.postSave();
            return o;
        }
        model.postSave();
        return this.driver.executeUpdate(updateOrInsert, preparedValues);
    }

    private void catchState() {
        if (!this.createdTables) {
            throw new IllegalStateException("You must call runMigrations() to seed Storm before you can use any api methods");
        }
    }

    public StormDriver getDriver() {
        return this.driver;
    }

    public Gson getGson() {
        return this.gson;
    }
}

