/*
 * Decompiled with CFR 0.152.
 */
package com.craftmend.storm.api.builders;

import com.craftmend.storm.Storm;
import com.craftmend.storm.api.StormModel;
import com.craftmend.storm.api.enums.Order;
import com.craftmend.storm.api.enums.Where;
import com.craftmend.storm.parser.ModelParser;
import com.craftmend.storm.parser.objects.ParsedField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class QueryBuilder<T extends StormModel> {
    private Class<T> model;
    private ModelParser<T> parser;
    private Integer limit = null;
    private List<WhereClause> whereClauseList = new ArrayList<WhereClause>();
    private OrderCause order = null;
    private Storm storm;
    private boolean or = false;

    public QueryBuilder(Class<T> modelClass, ModelParser<T> parser, Storm storm) {
        this.model = modelClass;
        this.parser = parser;
        this.storm = storm;
    }

    public QueryBuilder<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public QueryBuilder<T> orderBy(String column, Order order) {
        this.order = new OrderCause(column, order);
        return this;
    }

    public QueryBuilder<T> or() {
        this.or = true;
        return this;
    }

    public QueryBuilder<T> where(String column, Where comparison, Object value) {
        this.whereClauseList.add(new WhereClause(column, comparison, value));
        return this;
    }

    public PreparedQuery build() {
        StringBuilder sql = new StringBuilder("SELECT * FROM " + this.parser.getTableName() + "");
        LinkedList<Object> values = new LinkedList<Object>();
        for (int i = 0; i < this.whereClauseList.size(); ++i) {
            WhereClause wc = this.whereClauseList.get(i);
            boolean isLast = i + 1 == this.whereClauseList.size();
            ParsedField f = this.parser.fieldByColumnName(wc.column);
            if (f == null) {
                throw new IllegalArgumentException("there's no column called " + wc.column + " in this model");
            }
            if (i == 0) {
                sql.append(" WHERE ");
            } else {
                sql.append(" ");
            }
            sql.append(wc.column).append(" ").append(wc.comparison.getSqlOp()).append(" ?");
            values.add(wc.value);
            if (isLast) continue;
            if (this.or) {
                this.or = false;
                sql.append(" OR");
                continue;
            }
            sql.append(" AND");
        }
        if (this.order != null) {
            ParsedField f = this.parser.fieldByColumnName(this.order.column);
            if (f == null) {
                throw new IllegalArgumentException("there's no column called " + this.order.column + " in this model");
            }
            sql.append(" ORDER BY " + this.order.column + " " + this.order.order.toString());
        }
        if (this.limit != null) {
            sql.append(" LIMIT " + this.limit);
        }
        Object[] preparedV = new Object[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            preparedV[i] = values.get(i);
        }
        PreparedQuery pq = new PreparedQuery();
        pq.query = sql.toString();
        pq.values = preparedV;
        return pq;
    }

    public CompletableFuture<Collection<T>> execute() throws Exception {
        return this.storm.executeQuery(this);
    }

    public Class<T> getModel() {
        return this.model;
    }

    public ModelParser<T> getParser() {
        return this.parser;
    }

    private class OrderCause {
        String column;
        Order order;

        public OrderCause(String column, Order order) {
            this.column = column;
            this.order = order;
        }
    }

    private class WhereClause {
        String column;
        Where comparison;
        Object value;

        public WhereClause(String column, Where comparison, Object value) {
            this.column = column;
            this.comparison = comparison;
            this.value = value;
        }
    }

    public class PreparedQuery {
        String query;
        Object[] values;

        public String getQuery() {
            return this.query;
        }

        public Object[] getValues() {
            return this.values;
        }
    }
}

