/*
 * Decompiled with CFR 0.152.
 */
package com.craftmend.storm.api.builders;

import com.craftmend.storm.Storm;
import com.craftmend.storm.api.StormModel;
import com.craftmend.storm.dialect.Dialect;
import com.craftmend.storm.parser.objects.ParsedField;
import com.craftmend.storm.utils.ColumnDefinition;
import java.util.ArrayList;

public class StatementBuilder {
    private StormModel model;

    public String buildSqlTableCreateStatement(Dialect dialect, Storm orm) {
        int i;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> footerConfigs = new ArrayList<String>();
        sb.append("CREATE TABLE " + this.model.parsed(orm).getTableName() + " (");
        for (i = 0; i < this.model.parsed(orm).getParsedFields().length; ++i) {
            ParsedField mf = this.model.parsed(orm).getParsedFields()[i];
            boolean isLast = this.model.parsed(orm).getParsedFields().length == i + 1;
            ColumnDefinition cd = dialect.compileColumn(mf);
            sb.append(" " + cd.getColumnSql() + (isLast ? "" : ","));
            if (cd.getConfigurationSql() == null) continue;
            footerConfigs.add(cd.getConfigurationSql());
        }
        i = 0;
        if (!footerConfigs.isEmpty()) {
            for (String footerConfig : footerConfigs) {
                sb.append(footerConfig);
                if (i == footerConfig.length()) {
                    sb.append(", ");
                }
                ++i;
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public StatementBuilder(StormModel model) {
        this.model = model;
    }
}

