/*
 * Decompiled with CFR 0.152.
 */
package com.craftmend.storm.connection.hikaricp;

import com.craftmend.storm.connection.StormDriver;
import com.craftmend.storm.dialect.Dialect;
import com.craftmend.storm.dialect.mariadb.MariaDialect;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class HikariDriver
implements StormDriver {
    private Dialect dialect = new MariaDialect();
    private HikariDataSource ds;

    public HikariDriver(HikariConfig hikariConfig) throws SQLException {
        this.ds = new HikariDataSource(hikariConfig);
    }

    public HikariDriver(HikariDataSource hikariDataSource) {
        this.ds = hikariDataSource;
    }

    @Override
    public void executeQuery(String query, StormDriver.Callback callback, Object ... arguments) throws Exception {
        try (Connection conn = this.ds.getConnection();
             PreparedStatement ps = conn.prepareStatement(query);){
            for (int i = 0; i < arguments.length; ++i) {
                ps.setObject(i + 1, arguments[i]);
            }
            callback.onAccept(ps.executeQuery());
        }
    }

    @Override
    public boolean execute(String query) throws SQLException {
        try (Connection conn = this.ds.getConnection();){
            boolean bl;
            block12: {
                Statement ps = conn.createStatement();
                try {
                    bl = ps.execute(query);
                    if (ps == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public int executeUpdate(String query, Object ... arguments) throws SQLException {
        try (Connection conn = this.ds.getConnection();){
            int n;
            block24: {
                ResultSet generated;
                int o;
                PreparedStatement ps;
                block21: {
                    int n2;
                    block23: {
                        block22: {
                            ps = conn.prepareStatement(query, 1);
                            for (int i = 0; i < arguments.length; ++i) {
                                ps.setObject(i + 1, arguments[i]);
                            }
                            o = ps.executeUpdate();
                            generated = ps.getGeneratedKeys();
                            if (!generated.next()) break block21;
                            n2 = generated.getInt(1);
                            if (generated == null) break block22;
                            generated.close();
                        }
                        if (ps == null) break block23;
                        ps.close();
                    }
                    return n2;
                }
                try {
                    block25: {
                        if (generated != null) {
                            generated.close();
                        }
                        break block25;
                        {
                            catch (Throwable throwable) {
                                if (generated != null) {
                                    try {
                                        generated.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    n = o;
                    if (ps == null) break block24;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return n;
        }
    }

    @Override
    public DatabaseMetaData getMeta() throws SQLException {
        try (Connection dsConnection = this.ds.getConnection();){
            DatabaseMetaData databaseMetaData = dsConnection.getMetaData();
            return databaseMetaData;
        }
    }

    @Override
    public boolean isOpen() {
        return this.ds != null && !this.ds.isClosed();
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            this.ds.close();
        }
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }
}

