/*
 * Decompiled with CFR 0.152.
 */
package com.craftmend.storm.connection.sqlite;

import com.craftmend.storm.connection.StormDriver;
import com.craftmend.storm.dialect.Dialect;
import com.craftmend.storm.dialect.sqlite.SqliteDialect;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SqliteFileDriver
implements StormDriver {
    private Connection conn;

    public SqliteFileDriver(File dataFile) throws SQLException {
        String url = "jdbc:sqlite:" + dataFile.getAbsolutePath();
        this.conn = DriverManager.getConnection(url);
    }

    @Override
    public void executeQuery(String query, StormDriver.Callback callback, Object ... arguments) throws Exception {
        try (PreparedStatement ps = this.conn.prepareStatement(query);){
            for (int i = 0; i < arguments.length; ++i) {
                ps.setObject(i + 1, arguments[i]);
            }
            callback.onAccept(ps.executeQuery());
        }
    }

    @Override
    public boolean execute(String query) throws SQLException {
        try (Statement ps = this.conn.createStatement();){
            boolean bl = ps.execute(query);
            return bl;
        }
    }

    @Override
    public int executeUpdate(String query, Object ... arguments) throws SQLException {
        try (PreparedStatement ps = this.conn.prepareStatement(query, 1);){
            for (int i = 0; i < arguments.length; ++i) {
                ps.setObject(i + 1, arguments[i]);
            }
            int o = ps.executeUpdate();
            try (ResultSet generated = ps.getGeneratedKeys();){
                if (generated.next()) {
                    int n = generated.getInt(1);
                    return n;
                }
            }
            int n = o;
            return n;
        }
    }

    @Override
    public DatabaseMetaData getMeta() throws SQLException {
        return this.conn.getMetaData();
    }

    @Override
    public boolean isOpen() {
        try {
            return this.conn != null && !this.conn.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public Dialect getDialect() {
        return new SqliteDialect();
    }
}

