/*
 * Decompiled with CFR 0.152.
 */
package com.craftmend.storm.gson;

import com.craftmend.storm.gson.TemporalFaker;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;

public class InstantTypeAdapter
implements JsonSerializer<Instant>,
JsonDeserializer<Instant> {
    @Override
    public Instant deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        return Instant.from(new TemporalFaker(jsonObject.get("seconds").getAsLong(), jsonObject.get("nanos").getAsInt()));
    }

    @Override
    public JsonElement serialize(Instant instant, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject result = new JsonObject();
        result.add("seconds", new JsonPrimitive(instant.getEpochSecond()));
        result.add("nanos", new JsonPrimitive(instant.getNano()));
        return result;
    }
}

