/*
 * Decompiled with CFR 0.152.
 */
package com.craftmend.storm.parser;

import com.craftmend.storm.Storm;
import com.craftmend.storm.api.StormModel;
import com.craftmend.storm.api.enums.ColumnType;
import com.craftmend.storm.api.enums.Where;
import com.craftmend.storm.api.markers.Column;
import com.craftmend.storm.parser.objects.ParsedField;
import com.craftmend.storm.parser.objects.RelationField;
import com.craftmend.storm.utils.Reflection;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ModelParser<T extends StormModel> {
    private boolean migrated = false;
    private final String tableName;
    private final ParsedField[] parsedFields;
    private List<RelationField> relationFields = new ArrayList<RelationField>();
    private Class<T> ownType;
    private Storm storm;
    private T emptyInstance;

    public ModelParser(Class<T> modelClazz, Storm storm, T emptyInstance) {
        this.tableName = Reflection.TableNameFromClass(modelClazz);
        this.ownType = modelClazz;
        this.storm = storm;
        this.emptyInstance = emptyInstance;
        ArrayList tempFields = new ArrayList();
        for (Field declaredField : Reflection.getAllFields(new ArrayList<Field>(), modelClazz)) {
            if (!declaredField.isAnnotationPresent(Column.class)) continue;
            if (Reflection.getAnnotatedColumnType(declaredField) == ColumnType.VALUE) {
                tempFields.add(new ParsedField(storm, modelClazz, declaredField.getType(), declaredField));
                continue;
            }
            this.relationFields.add(new RelationField(storm, modelClazz, declaredField.getType(), declaredField));
        }
        this.parsedFields = new ParsedField[tempFields.size()];
        tempFields.toArray(this.parsedFields);
    }

    public ParsedField fieldByColumnName(String columnName) {
        for (ParsedField parsedField : this.parsedFields) {
            if (!parsedField.getColumnName().equals(columnName)) continue;
            return parsedField;
        }
        return null;
    }

    public T fromResultSet(ResultSet resultSet, List<RelationField> relationFields) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException, SQLException {
        StormModel emptySelf = (StormModel)this.ownType.getConstructor(new Class[0]).newInstance(new Object[0]);
        for (ParsedField parsedField : this.parsedFields) {
            Object value = parsedField.getAdapter().fromSql(parsedField, resultSet.getObject(parsedField.getColumnName()));
            parsedField.getReflectedField().setAccessible(true);
            parsedField.getReflectedField().set(emptySelf, value);
        }
        for (RelationField relationField : relationFields) {
            try {
                Collection<T> childValues = this.storm.buildQuery(relationField.getTargetParser().ownType).where(relationField.getMatchToField(), Where.EQUAL, emptySelf.getId()).execute().join();
                relationField.getReflectedField().setAccessible(true);
                ArrayList<T> list = new ArrayList<T>();
                for (T childValue : childValues) {
                    list.add(childValue);
                }
                relationField.getReflectedField().set(emptySelf, list);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("Couldn't fulfil child values for " + relationField.getModel().getName() + "." + relationField.getReflectedField().getName() + ". Error: " + e.getMessage());
            }
        }
        return (T)emptySelf;
    }

    public boolean isMigrated() {
        return this.migrated;
    }

    public void setMigrated(boolean migrated) {
        this.migrated = migrated;
    }

    public String getTableName() {
        return this.tableName;
    }

    public ParsedField[] getParsedFields() {
        return this.parsedFields;
    }

    public List<RelationField> getRelationFields() {
        return this.relationFields;
    }

    public Class<T> getOwnType() {
        return this.ownType;
    }

    public Storm getStorm() {
        return this.storm;
    }

    public T getEmptyInstance() {
        return this.emptyInstance;
    }
}

