/*
 * Decompiled with CFR 0.152.
 */
package com.craftmend.storm.parser.objects;

import com.craftmend.storm.Storm;
import com.craftmend.storm.api.StormModel;
import com.craftmend.storm.api.enums.KeyType;
import com.craftmend.storm.parser.types.TypeRegistry;
import com.craftmend.storm.parser.types.objects.StormTypeAdapter;
import com.craftmend.storm.utils.Reflection;
import java.lang.reflect.Field;

public class ParsedField<T> {
    private Class type;
    private String javaFieldName;
    private String columnName;
    private StormTypeAdapter<T> adapter;
    private Class<? extends StormModel> model;
    private int max;
    private KeyType keyType;
    private boolean unique;
    private boolean autoIncrement;
    private boolean notNull;
    private boolean useBlob;
    private String defaultValue;
    private Field reflectedField;
    private Storm storm;

    public ParsedField(Storm storm, Class<? extends StormModel> modelClass, Class<T> type, Field field) {
        this.storm = storm;
        this.model = modelClass;
        this.type = type;
        this.javaFieldName = field.getName();
        this.columnName = Reflection.getAnnotatedFieldName(field);
        this.max = Reflection.getAnnotatedFieldMax(field);
        this.keyType = Reflection.getAnnotatedKeyType(field);
        this.unique = Reflection.getAnnotatedUnique(field);
        this.autoIncrement = Reflection.getAnnotatedAutoIncrement(field);
        this.notNull = Reflection.getAnnotatedNotNull(field);
        this.defaultValue = Reflection.getAnnotatedDefaultValue(field);
        this.useBlob = Reflection.getAnnotatedUseBlob(field);
        this.reflectedField = field;
        this.adapter = TypeRegistry.getAdapterFor(this);
    }

    public Object valueOn(StormModel model) {
        this.reflectedField.setAccessible(true);
        return this.adapter.toSql(this.storm, this.reflectedField.get(model));
    }

    public Object toSqlStringType(Object toEscape) {
        return this.adapter.escapeAsString() ? "'" + toEscape + "'" : toEscape;
    }

    public Class getType() {
        return this.type;
    }

    public String getJavaFieldName() {
        return this.javaFieldName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public StormTypeAdapter<T> getAdapter() {
        return this.adapter;
    }

    public Class<? extends StormModel> getModel() {
        return this.model;
    }

    public int getMax() {
        return this.max;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public boolean isUseBlob() {
        return this.useBlob;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Field getReflectedField() {
        return this.reflectedField;
    }

    public Storm getStorm() {
        return this.storm;
    }
}

