/*
 * Decompiled with CFR 0.152.
 */
package com.craftmend.storm.parser.objects;

import com.craftmend.storm.Storm;
import com.craftmend.storm.api.StormModel;
import com.craftmend.storm.parser.ModelParser;
import com.craftmend.storm.utils.Reflection;
import java.lang.reflect.Field;

public class RelationField<T> {
    private Class type;
    private String javaFieldName;
    private String columnName;
    private Class<? extends StormModel> model;
    private Field reflectedField;
    private Storm storm;
    private String matchToField;

    public RelationField(Storm storm, Class<? extends StormModel> modelClass, Class<T> type, Field field) {
        this.storm = storm;
        this.model = modelClass;
        this.type = type;
        this.javaFieldName = field.getName();
        this.columnName = Reflection.getAnnotatedFieldName(field);
        this.matchToField = Reflection.getAnnotatedMatchTo(field);
        this.reflectedField = field;
    }

    public ModelParser getTargetParser() {
        return this.storm.getParsedModel(this.getMatchToType(), false);
    }

    public Class<? extends StormModel> getMatchToType() {
        return Reflection.getAnnotatedReference(this.storm, this.reflectedField).getOwnType();
    }

    public Class getType() {
        return this.type;
    }

    public String getJavaFieldName() {
        return this.javaFieldName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Class<? extends StormModel> getModel() {
        return this.model;
    }

    public Field getReflectedField() {
        return this.reflectedField;
    }

    public Storm getStorm() {
        return this.storm;
    }

    public String getMatchToField() {
        return this.matchToField;
    }
}

