/*
 * Decompiled with CFR 0.152.
 */
package com.jazzkuh.modulemanager.common;

import com.jazzkuh.modulemanager.common.loader.ModuleFinder;
import com.jazzkuh.modulemanager.common.modules.AbstractModule;
import com.jazzkuh.modulemanager.common.modules.components.ComponentRegistry;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;

public class ModuleManager {
    private final Logger logger;
    private State state;
    private boolean debug;
    protected ComponentRegistry componentRegistry;
    private final Map<Class<? extends AbstractModule<?>>, AbstractModule<?>> modules;

    public ModuleManager(Logger logger) {
        this.logger = logger;
        this.state = State.IDLE;
        this.modules = new LinkedHashMap();
        this.componentRegistry = new ComponentRegistry(this);
        this.debug = false;
    }

    public void prepare(AbstractModule<?> module) {
        if (this.modules.containsKey(module.getClass())) {
            throw new IllegalArgumentException("Module is already registered");
        }
        this.modules.put(module.getClass(), module);
    }

    public void scanModules(Class<?> rootClass) {
        this.scanModules(rootClass.getPackage().getName());
    }

    public void scanModules(String rootPackage) {
        ModuleFinder moduleFinder = new ModuleFinder(this);
        for (Class<? extends AbstractModule<?>> clazz : moduleFinder.getModulesInOrder(rootPackage).keySet()) {
            AbstractModule<?> module = moduleFinder.getModulesInOrder(rootPackage).get(clazz);
            if (!module.shouldLoad()) continue;
            this.modules.put(clazz, module);
        }
    }

    public void load() {
        if (!this.state.equals((Object)State.IDLE)) {
            throw new IllegalStateException("ModuleManager is not in IDLE state");
        }
        this.state = State.LOAD;
        for (AbstractModule<?> module : this.modules.values()) {
            try {
                module.load();
            }
            catch (Throwable throwable) {
                this.logger.error(String.valueOf(throwable));
            }
        }
    }

    public void enable() {
        if (!this.state.equals((Object)State.LOAD)) {
            throw new IllegalStateException("ModuleManager is not in LOAD state");
        }
        this.state = State.ENABLE;
        for (AbstractModule<?> module : this.modules.values()) {
            try {
                module.enable();
            }
            catch (Throwable throwable) {
                this.logger.error(String.valueOf(throwable));
            }
        }
    }

    public void disable() {
        if (!this.state.equals((Object)State.ENABLE)) {
            throw new IllegalStateException("ModuleManager is not in ENABLE state");
        }
        this.state = State.DISABLE;
        LinkedList reversedModules = new LinkedList(this.modules.values());
        Collections.reverse(reversedModules);
        for (AbstractModule<?> module : this.modules.values()) {
            try {
                module.disable();
            }
            catch (Throwable throwable) {
                this.logger.error(String.valueOf(throwable));
            }
        }
    }

    public <M extends AbstractModule<?>> M get(Class<M> clazz) {
        AbstractModule<?> module = this.modules.get(clazz);
        if (module == null || !module.getClass().equals(clazz)) {
            throw new IllegalArgumentException("Module is not registered");
        }
        return (M)((AbstractModule)clazz.cast(module));
    }

    public void debug(boolean debug) {
        this.debug = debug;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public State getState() {
        return this.state;
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public Map<Class<? extends AbstractModule<?>>, AbstractModule<?>> getModules() {
        return this.modules;
    }

    @Generated
    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    public static enum State {
        IDLE,
        LOAD,
        ENABLE,
        DISABLE;

    }
}

