/*
 * Decompiled with CFR 0.152.
 */
package com.jazzkuh.modulemanager.common.loader;

import com.jazzkuh.modulemanager.common.loader.ScannedModule;
import com.jazzkuh.modulemanager.common.modules.AbstractModule;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DependencyTree {
    private final Map<Class<? extends AbstractModule<?>>, ScannedModule> scannedModuleHashMap = new HashMap();
    private final Map<ScannedModule, List<Class<? extends AbstractModule<?>>>> dependencyMap = new HashMap();

    public void registerDependency(ScannedModule scannedModule) {
        ArrayList dependencyList = new ArrayList();
        this.scannedModuleHashMap.put(scannedModule.moduleClass(), scannedModule);
        for (int i = 1; i < scannedModule.dependencies().size(); ++i) {
            Class<?> dependency = scannedModule.dependencies().get(i);
            if (!AbstractModule.class.isAssignableFrom(dependency)) continue;
            dependencyList.add(dependency);
        }
        this.dependencyMap.put(scannedModule, dependencyList);
    }

    public boolean hasLoop() {
        HashSet history = new HashSet();
        for (Map.Entry<ScannedModule, List<Class<AbstractModule<?>>>> entry : this.dependencyMap.entrySet()) {
            if (this.checkDependencies(entry.getKey(), history)) continue;
            return true;
        }
        return false;
    }

    private boolean checkDependencies(ScannedModule scannedModule, Set<Class<? extends AbstractModule<?>>> history) {
        for (Class<? extends AbstractModule<?>> clazz : this.dependencyMap.get(scannedModule)) {
            if (history.contains(clazz)) {
                return false;
            }
            HashSet newHistory = new HashSet(history);
            newHistory.add(clazz);
            if (this.checkDependencies(this.scannedModuleHashMap.get(clazz), newHistory)) continue;
            return false;
        }
        return true;
    }

    public List<ScannedModule> getSortedDependencies() {
        return this.dependencyMap.entrySet().stream().sorted(Comparator.comparingInt(value -> ((List)value.getValue()).size())).map(Map.Entry::getKey).toList();
    }
}

