/*
 * Decompiled with CFR 0.152.
 */
package com.jazzkuh.modulemanager.common.loader;

import com.jazzkuh.modulemanager.common.ModuleManager;
import com.jazzkuh.modulemanager.common.loader.DependencyTree;
import com.jazzkuh.modulemanager.common.loader.ScannedModule;
import com.jazzkuh.modulemanager.common.modules.AbstractModule;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public final class ModuleFinder {
    private final Map<Class<? extends AbstractModule<?>>, AbstractModule<?>> createdModules = new LinkedHashMap();
    private final ModuleManager moduleManager;

    public ModuleFinder(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public Map<Class<? extends AbstractModule<?>>, AbstractModule<?>> getModulesInOrder(String rootPackage) {
        DependencyTree dependencyTree = new DependencyTree();
        for (Class<? extends AbstractModule<?>> clazz : ModuleFinder.scanPackage(rootPackage)) {
            Constructor<?> injectionConstructor = this.getInjectionConstructor(clazz);
            Class<?>[] dependencies = injectionConstructor.getParameterTypes();
            ScannedModule scannedModule = new ScannedModule(clazz, injectionConstructor, Arrays.asList(dependencies));
            dependencyTree.registerDependency(scannedModule);
        }
        if (dependencyTree.hasLoop()) {
            throw new IllegalStateException("Dependency loop detected");
        }
        for (ScannedModule scannedModule : dependencyTree.getSortedDependencies()) {
            List collect = scannedModule.dependencies().subList(1, scannedModule.dependencies().size()).stream().map(this.createdModules::get).collect(Collectors.toList());
            collect.add(0, this.moduleManager);
            try {
                this.createdModules.put(scannedModule.moduleClass(), (AbstractModule)scannedModule.injectionConstructor().newInstance(collect.toArray()));
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create instance of " + scannedModule.moduleClass().getName(), e);
            }
        }
        return this.createdModules;
    }

    private static Set<Class<? extends AbstractModule<?>>> scanPackage(String rootPackage) {
        Reflections reflections = new Reflections(rootPackage, new Scanner[0]);
        return reflections.getSubTypesOf(AbstractModule.class).stream().filter(clazz -> !Modifier.isAbstract(clazz.getModifiers())).map(clazz -> clazz).collect(Collectors.toSet());
    }

    private Constructor<?> getInjectionConstructor(Class<? extends AbstractModule<?>> clazz) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length == 0 || !ModuleManager.class.isAssignableFrom(parameterTypes[0])) continue;
            boolean continueLoop = false;
            for (int i = 1; i < parameterTypes.length; ++i) {
                if (AbstractModule.class.isAssignableFrom(parameterTypes[i])) continue;
                continueLoop = true;
                break;
            }
            if (continueLoop) continue;
            return constructor;
        }
        throw new IllegalStateException("No valid constructor found for " + clazz.getName());
    }
}

