/*
 * Decompiled with CFR 0.152.
 */
package com.jazzkuh.modulemanager.common.modules;

import com.jazzkuh.modulemanager.common.ModuleManager;
import com.jazzkuh.modulemanager.common.modules.components.ComponentRegistry;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModule<M extends ModuleManager> {
    private boolean enabled;
    private final M owningManager;
    private final ComponentRegistry registry;
    private final List<Object> components;
    private final Logger logger;

    protected AbstractModule(M owningManager) {
        this.owningManager = owningManager;
        this.registry = ((ModuleManager)owningManager).getComponentRegistry();
        this.components = new ArrayList<Object>();
        this.logger = LoggerFactory.getLogger(this.getClass().getSimpleName());
    }

    public final void load() {
        this.onLoad();
        this.registry.execute(ModuleManager.State.LOAD, this.components);
    }

    public void onLoad() {
    }

    public final void enable() {
        this.onEnable();
        this.registry.execute(ModuleManager.State.ENABLE, this.components);
        this.enabled = true;
    }

    public void onEnable() {
    }

    public final void disable() {
        if (((ModuleManager)this.owningManager).isDebug()) {
            this.getLogger().info("Disabling module: " + this.getName());
        }
        this.onDisable();
        this.registry.execute(ModuleManager.State.DISABLE, this.components);
    }

    public void onDisable() {
    }

    public boolean shouldLoad() {
        return true;
    }

    public void registerComponent(Object component) {
        if (!this.registry.isClassRegistered(component.getClass())) {
            throw new IllegalArgumentException("Component class is not registered in the registry");
        }
        if (((ModuleManager)this.owningManager).isDebug()) {
            this.getLogger().info("Registering component: " + component.getClass().getSimpleName());
        }
        this.components.add(component);
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public M getOwningManager() {
        return this.owningManager;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }
}

