/*
 * Decompiled with CFR 0.152.
 */
package com.jazzkuh.modulemanager.common.modules.components;

import com.jazzkuh.modulemanager.common.ModuleManager;
import com.jazzkuh.modulemanager.common.modules.components.IComponentHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class ComponentRegistry {
    private final ModuleManager moduleManager;
    protected Map<Class<?>, IComponentHandler<?>> componentHandlerMap = new HashMap();

    public <C> void registerComponentHandler(Class<C> componentClass, IComponentHandler<?> handler) {
        this.componentHandlerMap.put(componentClass, handler);
    }

    public <C> void execute(ModuleManager.State state, List<C> object) {
        this.execute(state, object.toArray());
    }

    public void execute(ModuleManager.State state, Object ... objects) {
        for (Object object : objects) {
            this.execute(state, object);
        }
    }

    public void execute(ModuleManager.State state, Object object) {
        boolean found = false;
        for (Map.Entry<Class<?>, IComponentHandler<?>> entry : this.componentHandlerMap.entrySet()) {
            if (!this.isClassRegistered(entry.getKey(), object.getClass())) continue;
            this.executeState(state, entry.getValue(), object);
            found = true;
        }
    }

    protected void executeState(ModuleManager.State state, IComponentHandler<Object> handler, Object object) {
        switch (state) {
            case LOAD: {
                handler.onLoad(this.moduleManager, object);
                break;
            }
            case ENABLE: {
                handler.onEnable(this.moduleManager, object);
                break;
            }
            case DISABLE: {
                handler.onDisable(this.moduleManager, object);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + String.valueOf((Object)state));
            }
        }
    }

    public boolean isClassRegistered(Class<?> clazz) {
        return this.componentHandlerMap.keySet().stream().anyMatch(componentClass -> this.isClassRegistered((Class<?>)componentClass, clazz));
    }

    private boolean isClassRegistered(Class<?> componentClass, Class<?> target) {
        return componentClass.isAssignableFrom(target) || componentClass.isAnnotation() && target.getDeclaredAnnotation(componentClass) != null;
    }

    @Generated
    public ComponentRegistry(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }
}

