/*
 * Decompiled with CFR 0.152.
 */
package com.jazzkuh.modulemanager.spigot.handlers.tasks;

import com.jazzkuh.modulemanager.common.ModuleManager;
import com.jazzkuh.modulemanager.common.modules.components.IComponentHandler;
import com.jazzkuh.modulemanager.spigot.SpigotModuleManager;
import com.jazzkuh.modulemanager.spigot.handlers.tasks.TaskInfo;
import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.scheduler.BukkitTask;

public final class TaskComponentHandler
implements IComponentHandler<Runnable> {
    private final Map<Runnable, BukkitTask> registeredTasks = new WeakHashMap<Runnable, BukkitTask>();

    @Override
    public void onLoad(ModuleManager manager, Runnable component) {
    }

    @Override
    public void onEnable(ModuleManager manager, Runnable component) {
        if (!(manager instanceof SpigotModuleManager)) {
            return;
        }
        SpigotModuleManager spigotModuleManager = (SpigotModuleManager)manager;
        Object plugin = spigotModuleManager.getPlugin();
        TaskInfo taskInfo = component.getClass().getAnnotation(TaskInfo.class);
        if (taskInfo == null) {
            throw new IllegalStateException("Component " + component.getClass().getName() + " is not annotated with @TaskInfo");
        }
        if (taskInfo.async()) {
            if (taskInfo.repeating()) {
                BukkitTask task = plugin.getServer().getScheduler().runTaskTimerAsynchronously(plugin, component, taskInfo.delay(), taskInfo.period());
                this.registeredTasks.put(component, task);
            } else if (taskInfo.delay() < 0L) {
                plugin.getServer().getScheduler().runTaskAsynchronously(plugin, component);
            } else {
                BukkitTask task = plugin.getServer().getScheduler().runTaskLaterAsynchronously(plugin, component, taskInfo.delay());
                this.registeredTasks.put(component, task);
            }
        } else if (taskInfo.repeating()) {
            BukkitTask task = plugin.getServer().getScheduler().runTaskTimer(plugin, component, taskInfo.delay(), taskInfo.period());
            this.registeredTasks.put(component, task);
        } else if (taskInfo.delay() < 0L) {
            plugin.getServer().getScheduler().runTask(plugin, component);
        } else {
            BukkitTask task = plugin.getServer().getScheduler().runTaskLater(plugin, component, taskInfo.delay());
            this.registeredTasks.put(component, task);
        }
    }

    @Override
    public void onDisable(ModuleManager manager, Runnable component) {
        BukkitTask task = this.registeredTasks.remove(component);
        if (task != null) {
            task.cancel();
        }
    }
}

