/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia;

import com.jazzkuh.modulemanager.spigot.SpigotModuleManager;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import nl.openminetopia.configuration.DefaultConfiguration;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.framework.runnables.AbstractDirtyRunnable;
import nl.openminetopia.framework.runnables.listeners.PlayerLifecycleListener;
import nl.openminetopia.registry.CommandComponentRegistry;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.MessageType;
import nl.openminetopia.shaded.acf.PaperCommandManager;
import nl.openminetopia.shaded.bstats.bukkit.Metrics;
import nl.openminetopia.shaded.bstats.charts.SimplePie;
import nl.openminetopia.shaded.customblockdata.CustomBlockData;
import nl.openminetopia.utils.input.ChatInputHandler;
import nl.openminetopia.utils.placeholderapi.OpenMinetopiaExpansion;
import nl.openminetopia.utils.wrappers.listeners.CitzensNpcClickListener;
import nl.openminetopia.utils.wrappers.listeners.FancyNpcClickListener;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class OpenMinetopia
extends JavaPlugin {
    private static OpenMinetopia instance;
    private static SpigotModuleManager<@NotNull OpenMinetopia> moduleManager;
    private static PaperCommandManager commandManager;
    private static DefaultConfiguration defaultConfiguration;
    private static MessageConfiguration messageConfiguration;
    private static ChatInputHandler chatInputHandler;
    private final List<AbstractDirtyRunnable<UUID>> dirtyPlayerRunnables = new CopyOnWriteArrayList<AbstractDirtyRunnable<UUID>>();
    private boolean npcSupport = false;
    private boolean labymodSupport = false;
    private Vertx vertx;

    public OpenMinetopia() {
        instance = this;
        moduleManager = new SpigotModuleManager<OpenMinetopia>(this, (Logger)this.getComponentLogger());
    }

    public void onEnable() {
        commandManager = new PaperCommandManager((Plugin)this);
        moduleManager.debug(false);
        messageConfiguration = new MessageConfiguration(this.getDataFolder());
        messageConfiguration.saveConfiguration();
        if (defaultConfiguration.isMetricsEnabled()) {
            Metrics metrics = new Metrics((Plugin)this, 23547);
            metrics.addCustomChart(new SimplePie("storage", () -> defaultConfiguration.getDatabaseType().toString()));
        }
        commandManager.enableUnstableAPI("help");
        commandManager.setFormat(MessageType.HELP, 1, ChatColor.GOLD);
        commandManager.setFormat(MessageType.HELP, 2, ChatColor.YELLOW);
        commandManager.setFormat(MessageType.HELP, 3, ChatColor.GRAY);
        chatInputHandler = new ChatInputHandler();
        Bukkit.getPluginManager().registerEvents((Listener)chatInputHandler, (Plugin)this);
        CustomBlockData.registerListener((Plugin)this);
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new OpenMinetopiaExpansion().register();
            this.getLogger().info("Registered PlaceholderAPI expansion.");
        }
        if (Bukkit.getPluginManager().isPluginEnabled("Citizens")) {
            this.getLogger().info("Initializing Citizens support.");
            Bukkit.getPluginManager().registerEvents((Listener)new CitzensNpcClickListener(), (Plugin)this);
            this.npcSupport = true;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("FancyNpcs")) {
            this.getLogger().info("Initializing FancyNpcs support.");
            Bukkit.getPluginManager().registerEvents((Listener)new FancyNpcClickListener(), (Plugin)this);
            this.npcSupport = true;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("LabyModServerAPI")) {
            this.getLogger().info("Initializing LabyModServerAPI support.");
            this.labymodSupport = true;
        }
        moduleManager.getComponentRegistry().registerComponentHandler(BaseCommand.class, new CommandComponentRegistry(commandManager));
        moduleManager.enable();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerLifecycleListener(this), (Plugin)this);
    }

    public void onDisable() {
        moduleManager.disable();
    }

    public void onLoad() {
        defaultConfiguration = new DefaultConfiguration(this.getDataFolder());
        defaultConfiguration.saveConfiguration();
        moduleManager.scanModules(((Object)((Object)this)).getClass());
        moduleManager.load();
    }

    public Vertx getOrCreateVertx() {
        if (this.vertx == null) {
            this.vertx = Vertx.vertx();
        }
        return this.vertx;
    }

    public void registerDirtyPlayerRunnable(AbstractDirtyRunnable<UUID> runnable, long periodTicks) {
        this.dirtyPlayerRunnables.add(runnable);
        runnable.start((Plugin)OpenMinetopia.getInstance(), periodTicks);
    }

    public void unregisterDirtyPlayerRunnable(AbstractDirtyRunnable<UUID> runnable) {
        this.dirtyPlayerRunnables.remove(runnable);
        runnable.cancel();
    }

    @Generated
    public boolean isNpcSupport() {
        return this.npcSupport;
    }

    @Generated
    public boolean isLabymodSupport() {
        return this.labymodSupport;
    }

    @Generated
    public Vertx getVertx() {
        return this.vertx;
    }

    @Generated
    public void setNpcSupport(boolean npcSupport) {
        this.npcSupport = npcSupport;
    }

    @Generated
    public void setLabymodSupport(boolean labymodSupport) {
        this.labymodSupport = labymodSupport;
    }

    @Generated
    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    @Generated
    public static OpenMinetopia getInstance() {
        return instance;
    }

    @Generated
    public static SpigotModuleManager<@NotNull OpenMinetopia> getModuleManager() {
        return moduleManager;
    }

    @Generated
    private static void setModuleManager(SpigotModuleManager<@NotNull OpenMinetopia> moduleManager) {
        OpenMinetopia.moduleManager = moduleManager;
    }

    @Generated
    public static PaperCommandManager getCommandManager() {
        return commandManager;
    }

    @Generated
    public static void setCommandManager(PaperCommandManager commandManager) {
        OpenMinetopia.commandManager = commandManager;
    }

    @Generated
    public static DefaultConfiguration getDefaultConfiguration() {
        return defaultConfiguration;
    }

    @Generated
    public static void setDefaultConfiguration(DefaultConfiguration defaultConfiguration) {
        OpenMinetopia.defaultConfiguration = defaultConfiguration;
    }

    @Generated
    public static MessageConfiguration getMessageConfiguration() {
        return messageConfiguration;
    }

    @Generated
    public static void setMessageConfiguration(MessageConfiguration messageConfiguration) {
        OpenMinetopia.messageConfiguration = messageConfiguration;
    }

    @Generated
    public static ChatInputHandler getChatInputHandler() {
        return chatInputHandler;
    }

    @Generated
    public List<AbstractDirtyRunnable<UUID>> getDirtyPlayerRunnables() {
        return this.dirtyPlayerRunnables;
    }
}

