/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.api.player;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.modules.player.PlayerModule;
import nl.openminetopia.modules.player.models.PlayerModel;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlayerManager {
    private static PlayerManager instance;
    private final PlayerModule playerModule = OpenMinetopia.getModuleManager().get(PlayerModule.class);
    private final Map<UUID, MinetopiaPlayer> onlinePlayers = new ConcurrentHashMap<UUID, MinetopiaPlayer>();
    private final Map<UUID, CompletableFuture<MinetopiaPlayer>> loadingPlayers = new ConcurrentHashMap<UUID, CompletableFuture<MinetopiaPlayer>>();

    public static PlayerManager getInstance() {
        if (instance == null) {
            instance = new PlayerManager();
        }
        return instance;
    }

    public MinetopiaPlayer getOnlineMinetopiaPlayer(Player player) {
        return this.onlinePlayers.get(player.getUniqueId());
    }

    public CompletableFuture<MinetopiaPlayer> getMinetopiaPlayer(OfflinePlayer player) {
        UUID uuid = player.getUniqueId();
        if (this.onlinePlayers.containsKey(uuid)) {
            return CompletableFuture.completedFuture(this.onlinePlayers.get(uuid));
        }
        return this.loadingPlayers.computeIfAbsent(uuid, id -> {
            CompletableFuture future = new CompletableFuture();
            this.playerModule.getPlayerModel(uuid).whenComplete((playerModel, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                    this.loadingPlayers.remove(uuid);
                    return;
                }
                MinetopiaPlayer minetopiaPlayer = new MinetopiaPlayer(uuid, (PlayerModel)playerModel);
                minetopiaPlayer.load().join();
                if (player.isOnline()) {
                    this.onlinePlayers.put(uuid, minetopiaPlayer);
                }
                future.complete(minetopiaPlayer);
                this.loadingPlayers.remove(uuid);
            });
            return future;
        });
    }

    @Generated
    public PlayerModule getPlayerModule() {
        return this.playerModule;
    }

    @Generated
    public Map<UUID, MinetopiaPlayer> getOnlinePlayers() {
        return this.onlinePlayers;
    }

    @Generated
    public Map<UUID, CompletableFuture<MinetopiaPlayer>> getLoadingPlayers() {
        return this.loadingPlayers;
    }
}

