/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.api.player;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.text.ComponentLike;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.modules.scoreboard.ScoreboardModule;
import nl.openminetopia.shaded.scoreboard.api.ScoreboardLibrary;
import nl.openminetopia.shaded.scoreboard.api.sidebar.Sidebar;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ScoreboardManager {
    private static ScoreboardManager instance;
    public final HashMap<UUID, Sidebar> scoreboards = new HashMap();
    private final ScoreboardLibrary scoreboardLibrary = OpenMinetopia.getModuleManager().get(ScoreboardModule.class).getScoreboardLibrary();

    public static ScoreboardManager getInstance() {
        if (instance == null) {
            instance = new ScoreboardManager();
        }
        return instance;
    }

    public void updateBoard(MinetopiaPlayer minetopiaPlayer) {
        Sidebar sidebar = this.getScoreboard(minetopiaPlayer.getUuid());
        if (sidebar == null) {
            return;
        }
        if (!minetopiaPlayer.isScoreboardVisible()) {
            return;
        }
        Player player = minetopiaPlayer.getBukkit().getPlayer();
        if (player == null) {
            return;
        }
        if (!minetopiaPlayer.isInPlace()) {
            if (sidebar.players().contains(player)) {
                this.removeScoreboard(player);
            }
            return;
        }
        if (!sidebar.players().contains(player)) {
            this.addScoreboard(player);
        }
        List<String> lines = OpenMinetopia.getDefaultConfiguration().getScoreboardLines();
        int size = Math.min(lines.size(), 16);
        for (int i = 0; i < size; ++i) {
            String line = lines.get(i);
            if (i == 0) {
                sidebar.title((ComponentLike)ChatUtils.format(minetopiaPlayer, line));
                continue;
            }
            sidebar.line(i - 1, (ComponentLike)ChatUtils.format(minetopiaPlayer, line));
        }
    }

    public void addScoreboard(Player player) {
        if (!OpenMinetopia.getDefaultConfiguration().isScoreboardEnabled()) {
            return;
        }
        if (this.scoreboards.containsKey(player.getUniqueId())) {
            return;
        }
        Sidebar sidebar = this.scoreboardLibrary.createSidebar();
        sidebar.addPlayer(player);
        this.scoreboards.put(player.getUniqueId(), sidebar);
    }

    public void removeScoreboard(Player player) {
        this.removeScoreboard(player.getUniqueId());
    }

    public void removeScoreboard(UUID uuid) {
        Sidebar sidebar = this.scoreboards.remove(uuid);
        if (sidebar != null) {
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p != null) {
                sidebar.removePlayer(p);
            }
            sidebar.close();
        }
    }

    public Sidebar getScoreboard(UUID uuid) {
        return this.scoreboards.get(uuid);
    }

    @Generated
    public HashMap<UUID, Sidebar> getScoreboards() {
        return this.scoreboards;
    }

    @Generated
    public ScoreboardLibrary getScoreboardLibrary() {
        return this.scoreboardLibrary;
    }
}

