/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.api.player.fitness;

import com.craftmend.storm.api.StormModel;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.fitness.FitnessStatisticType;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.modules.data.storm.StormDatabase;
import nl.openminetopia.modules.fitness.FitnessModule;
import nl.openminetopia.modules.fitness.models.FitnessBoosterModel;
import nl.openminetopia.modules.fitness.models.FitnessStatisticModel;
import nl.openminetopia.modules.fitness.utils.FitnessUtils;
import nl.openminetopia.modules.player.models.PlayerModel;
import org.bukkit.Bukkit;
import org.bukkit.Statistic;
import org.jetbrains.annotations.NotNull;

public class Fitness {
    private final MinetopiaPlayer minetopiaPlayer;
    private final UUID uuid;
    private final PlayerModel playerModel;
    private boolean fitnessReset;
    private int totalFitness;
    private final FitnessModule fitnessModule = OpenMinetopia.getModuleManager().get(FitnessModule.class);

    public Fitness(MinetopiaPlayer minetopiaPlayer) {
        this.minetopiaPlayer = minetopiaPlayer;
        this.uuid = minetopiaPlayer.getUuid();
        this.playerModel = minetopiaPlayer.getPlayerModel();
        this.fitnessReset = this.playerModel.getFitnessReset();
    }

    public CompletableFuture<Void> save() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        StormDatabase.getInstance().saveStormModel(this.playerModel);
        this.playerModel.getBoosters().forEach(StormDatabase.getInstance()::saveStormModel);
        this.playerModel.getStatistics().forEach(StormDatabase.getInstance()::saveStormModel);
        future.complete(null);
        return future;
    }

    public void apply() {
        FitnessUtils.applyFitness(Bukkit.getPlayer((UUID)this.uuid));
    }

    public void setLastDrinkingTime(long time) {
        this.fitnessModule.getLastDrinkingTimes().put(this.uuid, time);
    }

    public long getLastDrinkingTime() {
        return this.fitnessModule.getLastDrinkingTimes().getOrDefault(this.uuid, 0L);
    }

    @NotNull
    public FitnessStatisticModel getStatistic(FitnessStatisticType type) {
        FitnessStatisticModel model = this.playerModel.getStatistics().stream().filter(statistic -> statistic.getType().equals((Object)type)).findFirst().orElse(null);
        if (model == null) {
            model = new FitnessStatisticModel();
            model.setPlayerId(this.playerModel.getId());
            model.setType(type);
            model.setFitnessGained(0);
            model.setPoints(0.0);
            model.setSecondaryPoints(0.0);
            model.setTertiaryPoints(0.0);
            this.playerModel.getStatistics().add(model);
            StormDatabase.getInstance().saveStormModel(model);
        }
        return model;
    }

    public void setStatistic(FitnessStatisticType type, FitnessStatisticModel model) {
        this.playerModel.getStatistics().stream().filter(statistic -> statistic.getType().equals((Object)type)).findFirst().ifPresent(statistic -> {
            statistic.setFitnessGained(model.getFitnessGained());
            statistic.setPoints(model.getPoints());
            statistic.setSecondaryPoints(model.getSecondaryPoints());
            statistic.setTertiaryPoints(model.getTertiaryPoints());
        });
    }

    public void addBooster(int amount, long expiresAtMillis) {
        FitnessBoosterModel boosterModel = new FitnessBoosterModel();
        boosterModel.setPlayerId(this.playerModel.getId());
        boosterModel.setAmount(amount);
        boosterModel.setExpiresAt(expiresAtMillis);
        this.playerModel.getBoosters().add(boosterModel);
        StormDatabase.getInstance().saveStormModel(boosterModel);
        this.fitnessModule.getFitnessRunnable().forceMarkDirty(this.minetopiaPlayer.getUuid());
    }

    public void removeBooster(FitnessBoosterModel booster) {
        this.playerModel.getBoosters().remove(booster);
        StormDatabase.getInstance().getStorm().delete(booster);
        this.fitnessModule.getFitnessRunnable().forceMarkDirty(this.minetopiaPlayer.getUuid());
    }

    public List<FitnessStatisticModel> getStatistics() {
        return this.playerModel.getStatistics();
    }

    public List<FitnessBoosterModel> getBoosters() {
        return this.playerModel.getBoosters();
    }

    public void setFitnessReset(boolean enabled) {
        this.fitnessReset = enabled;
        this.playerModel.setFitnessReset(enabled);
        StormDatabase.getInstance().saveStormModel(this.playerModel);
    }

    public void reset() {
        this.setFitnessReset(false);
        this.minetopiaPlayer.getBukkit().setStatistic(Statistic.WALK_ONE_CM, 0);
        this.minetopiaPlayer.getBukkit().setStatistic(Statistic.CLIMB_ONE_CM, 0);
        this.minetopiaPlayer.getBukkit().setStatistic(Statistic.SPRINT_ONE_CM, 0);
        this.minetopiaPlayer.getBukkit().setStatistic(Statistic.SWIM_ONE_CM, 0);
        this.minetopiaPlayer.getBukkit().setStatistic(Statistic.AVIATE_ONE_CM, 0);
        List<FitnessStatisticModel> statistics = this.playerModel.getStatistics();
        statistics.forEach(statistic -> {
            statistic.setFitnessGained(0);
            statistic.setPoints(0.0);
            statistic.setSecondaryPoints(0.0);
            statistic.setTertiaryPoints(0.0);
            StormDatabase.getInstance().saveStormModel((StormModel)statistic);
        });
        List<FitnessBoosterModel> boosters = this.playerModel.getBoosters();
        boosters.forEach(booster -> {
            try {
                StormDatabase.getInstance().getStorm().delete((StormModel)booster);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
        this.playerModel.getBoosters().clear();
        this.totalFitness = OpenMinetopia.getModuleManager().get(FitnessModule.class).getConfiguration().getDefaultFitnessLevel();
        FitnessUtils.clearFitnessEffects(this.minetopiaPlayer.getBukkit().getPlayer());
        this.save();
        this.fitnessModule.getFitnessRunnable().forceMarkDirty(this.minetopiaPlayer.getUuid());
    }

    @Generated
    public MinetopiaPlayer getMinetopiaPlayer() {
        return this.minetopiaPlayer;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public PlayerModel getPlayerModel() {
        return this.playerModel;
    }

    @Generated
    public boolean isFitnessReset() {
        return this.fitnessReset;
    }

    @Generated
    public int getTotalFitness() {
        return this.totalFitness;
    }

    @Generated
    public FitnessModule getFitnessModule() {
        return this.fitnessModule;
    }

    @Generated
    public void setTotalFitness(int totalFitness) {
        this.totalFitness = totalFitness;
    }
}

