/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.api.player.objects;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.places.MTPlaceManager;
import nl.openminetopia.api.places.objects.MTPlace;
import nl.openminetopia.api.player.fitness.Fitness;
import nl.openminetopia.configuration.DefaultConfiguration;
import nl.openminetopia.modules.color.ColorModule;
import nl.openminetopia.modules.color.enums.OwnableColorType;
import nl.openminetopia.modules.color.objects.ChatColor;
import nl.openminetopia.modules.color.objects.LevelColor;
import nl.openminetopia.modules.color.objects.NameColor;
import nl.openminetopia.modules.color.objects.OwnableColor;
import nl.openminetopia.modules.color.objects.PrefixColor;
import nl.openminetopia.modules.currencies.CurrencyModule;
import nl.openminetopia.modules.currencies.models.CurrencyModel;
import nl.openminetopia.modules.data.storm.StormDatabase;
import nl.openminetopia.modules.fitness.FitnessModule;
import nl.openminetopia.modules.places.PlacesModule;
import nl.openminetopia.modules.places.models.WorldModel;
import nl.openminetopia.modules.player.PlayerModule;
import nl.openminetopia.modules.player.models.PlayerModel;
import nl.openminetopia.modules.police.PoliceModule;
import nl.openminetopia.modules.police.models.CriminalRecordModel;
import nl.openminetopia.modules.prefix.PrefixModule;
import nl.openminetopia.modules.prefix.objects.Prefix;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class MinetopiaPlayer {
    private final UUID uuid;
    private final PlayerModel playerModel;
    private boolean scoreboardVisible;
    private boolean actionbarVisible;
    private long playtime;
    private long wageTime;
    private transient long startTime;
    private int level;
    private int calculatedLevel;
    private boolean staffchatEnabled;
    private boolean commandSpyEnabled;
    private boolean chatSpyEnabled;
    private List<Prefix> prefixes;
    private Prefix activePrefix;
    private List<OwnableColor> colors;
    private PrefixColor activePrefixColor;
    private NameColor activeNameColor;
    private ChatColor activeChatColor;
    private LevelColor activeLevelColor;
    private Fitness fitness;
    private final PlayerModule playerModule = OpenMinetopia.getModuleManager().get(PlayerModule.class);
    private final PrefixModule prefixModule = OpenMinetopia.getModuleManager().get(PrefixModule.class);
    private final ColorModule colorModule = OpenMinetopia.getModuleManager().get(ColorModule.class);
    private final PlacesModule placesModule = OpenMinetopia.getModuleManager().get(PlacesModule.class);
    private final PoliceModule policeModule = OpenMinetopia.getModuleManager().get(PoliceModule.class);
    private final CurrencyModule currencyModule = OpenMinetopia.getModuleManager().get(CurrencyModule.class);

    public MinetopiaPlayer(UUID uuid, PlayerModel playerModel) {
        this.uuid = uuid;
        this.playerModel = playerModel;
    }

    public CompletableFuture<Void> load() {
        CompletableFuture<Void> loadFuture = new CompletableFuture<Void>();
        DefaultConfiguration configuration = OpenMinetopia.getDefaultConfiguration();
        if (this.getBukkit().getPlayer() != null && this.getBukkit().isOnline()) {
            this.getBukkit().getPlayer().sendMessage(ChatUtils.color("<red>Je data wordt geladen..."));
        }
        if (!OpenMinetopia.getDefaultConfiguration().isModuleDisabled(FitnessModule.class)) {
            this.fitness = new Fitness(this);
        }
        this.playtime = this.playerModel.getPlaytime();
        this.wageTime = this.playerModel.getWageTime();
        this.startTime = System.currentTimeMillis();
        this.level = this.playerModel.getLevel();
        this.calculatedLevel = configuration.getDefaultLevel();
        this.staffchatEnabled = this.playerModel.getStaffchatEnabled();
        this.commandSpyEnabled = this.playerModel.getCommandSpyEnabled();
        this.chatSpyEnabled = this.playerModel.getChatSpyEnabled();
        this.colors = this.colorModule.getColorsFromPlayer(this.playerModel);
        this.activeChatColor = (ChatColor)this.colorModule.getActiveColorFromPlayer(this.playerModel, OwnableColorType.CHAT).orElse(OwnableColorType.CHAT.defaultColor());
        this.activeNameColor = (NameColor)this.colorModule.getActiveColorFromPlayer(this.playerModel, OwnableColorType.NAME).orElse(OwnableColorType.NAME.defaultColor());
        this.activePrefixColor = (PrefixColor)this.colorModule.getActiveColorFromPlayer(this.playerModel, OwnableColorType.PREFIX).orElse(OwnableColorType.PREFIX.defaultColor());
        this.activeLevelColor = (LevelColor)this.colorModule.getActiveColorFromPlayer(this.playerModel, OwnableColorType.LEVEL).orElse(OwnableColorType.LEVEL.defaultColor());
        this.prefixes = this.prefixModule.getPrefixesFromPlayer(this.playerModel);
        this.activePrefix = this.prefixModule.getActivePrefixFromPlayer(this.playerModel).orElse(new Prefix(-1, configuration.getDefaultPrefix(), -1L));
        loadFuture.complete(null);
        return loadFuture;
    }

    public CompletableFuture<Void> save() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        StormDatabase.getInstance().saveStormModel(this.playerModel);
        if (!OpenMinetopia.getDefaultConfiguration().isModuleDisabled(FitnessModule.class)) {
            this.fitness.save();
        }
        future.complete(null);
        return future;
    }

    public OfflinePlayer getBukkit() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid);
    }

    public boolean isInPlace() {
        return this.getPlace() != null;
    }

    public MTPlace getPlace() {
        return MTPlaceManager.getInstance().getPlace(this.getBukkit().getLocation());
    }

    public WorldModel getWorld() {
        if (this.getBukkit().getPlayer() == null) {
            return null;
        }
        return this.placesModule.getWorldModels().stream().filter(worldModel -> worldModel.getName().equalsIgnoreCase(this.getBukkit().getPlayer().getWorld().getName())).findFirst().orElse(null);
    }

    public void setLevel(int level) {
        if (level < 0) {
            return;
        }
        this.level = level;
        this.playerModel.setLevel(level);
        StormDatabase.getInstance().saveStormModel(this.playerModel);
    }

    public void setStaffchatEnabled(boolean staffchatEnabled) {
        this.staffchatEnabled = staffchatEnabled;
        this.playerModel.setStaffchatEnabled(staffchatEnabled);
        StormDatabase.getInstance().saveStormModel(this.playerModel);
    }

    public void setCommandSpyEnabled(boolean commandSpyEnabled) {
        this.commandSpyEnabled = commandSpyEnabled;
        this.playerModel.setCommandSpyEnabled(commandSpyEnabled);
        StormDatabase.getInstance().saveStormModel(this.playerModel);
    }

    public void setChatSpyEnabled(boolean chatSpyEnabled) {
        this.chatSpyEnabled = chatSpyEnabled;
        this.playerModel.setChatSpyEnabled(chatSpyEnabled);
        StormDatabase.getInstance().saveStormModel(this.playerModel);
    }

    public void addPrefix(Prefix prefix) {
        this.prefixModule.addPrefix(this, prefix).whenComplete((id, throwable) -> {
            if (throwable != null) {
                OpenMinetopia.getInstance().getLogger().severe("Failed to add prefix: " + throwable.getMessage());
                return;
            }
            this.prefixes.add(new Prefix((int)id, prefix.getPrefix(), prefix.getExpiresAt()));
        });
    }

    public void removePrefix(Prefix prefix) {
        DefaultConfiguration configuration = OpenMinetopia.getDefaultConfiguration();
        this.prefixes.remove(prefix);
        if (this.activePrefix == prefix) {
            this.activePrefix = new Prefix(-1, configuration.getDefaultPrefix(), -1L);
            this.setActivePrefix(this.activePrefix);
        }
        this.prefixModule.removePrefix(prefix);
    }

    public void setActivePrefix(Prefix prefix) {
        this.activePrefix = prefix;
        this.playerModel.setActivePrefixId(prefix.getId());
    }

    public Prefix getActivePrefix() {
        DefaultConfiguration configuration = OpenMinetopia.getDefaultConfiguration();
        if (this.activePrefix == null) {
            this.activePrefix = new Prefix(-1, configuration.getDefaultPrefix(), -1L);
        }
        if (this.activePrefix.isExpired()) {
            Player player = this.getBukkit().getPlayer();
            if (player != null && player.isOnline()) {
                player.sendMessage(ChatUtils.color("<red>Je prefix <dark_red>" + this.activePrefix.getPrefix() + " <red>is verlopen!"));
            }
            this.removePrefix(this.activePrefix);
            this.setActivePrefix(new Prefix(-1, configuration.getDefaultPrefix(), -1L));
        }
        return this.activePrefix;
    }

    public void addColor(OwnableColor color) {
        this.colorModule.addColor(this, color).whenComplete((id, throwable) -> {
            if (throwable != null) {
                OpenMinetopia.getInstance().getLogger().severe("Failed to add color: " + throwable.getMessage());
                return;
            }
            switch (color.getType()) {
                case PREFIX: {
                    this.colors.add(new PrefixColor((int)id, color.getColorId(), color.getExpiresAt()));
                    break;
                }
                case NAME: {
                    this.colors.add(new NameColor((int)id, color.getColorId(), color.getExpiresAt()));
                    break;
                }
                case CHAT: {
                    this.colors.add(new ChatColor((int)id, color.getColorId(), color.getExpiresAt()));
                    break;
                }
                case LEVEL: {
                    this.colors.add(new LevelColor((int)id, color.getColorId(), color.getExpiresAt()));
                }
            }
        });
    }

    public void removeColor(OwnableColor color) {
        this.colors.remove(color);
        this.colorModule.removeColor(color);
    }

    public void setActiveColor(OwnableColor color, OwnableColorType type) {
        if (color == null || color.getId() == 0) {
            color = type.defaultColor();
        }
        switch (type) {
            case PREFIX: {
                this.activePrefixColor = (PrefixColor)color;
                this.playerModel.setActivePrefixColorId(color.getId());
                break;
            }
            case NAME: {
                this.activeNameColor = (NameColor)color;
                this.playerModel.setActiveNameColorId(color.getId());
                break;
            }
            case CHAT: {
                this.activeChatColor = (ChatColor)color;
                this.playerModel.setActiveChatColorId(color.getId());
                break;
            }
            case LEVEL: {
                this.activeLevelColor = (LevelColor)color;
                this.playerModel.setActiveLevelColorId(color.getId());
            }
        }
    }

    public OwnableColor getActiveColor(OwnableColorType type) {
        OwnableColor color;
        switch (type) {
            default: {
                throw new MatchException(null, null);
            }
            case PREFIX: {
                OwnableColor ownableColor = this.activePrefixColor;
                break;
            }
            case NAME: {
                OwnableColor ownableColor = this.activeNameColor;
                break;
            }
            case CHAT: {
                OwnableColor ownableColor = this.activeChatColor;
                break;
            }
            case LEVEL: {
                OwnableColor ownableColor = color = this.activeLevelColor;
            }
        }
        if (color == null || color.getId() == 0) {
            color = type.defaultColor();
        }
        if (color.isExpired()) {
            Player player = this.getBukkit().getPlayer();
            if (player != null && player.isOnline()) {
                player.sendMessage(ChatUtils.color("<red>Je " + type.name().toLowerCase() + " kleur <dark_red>" + color.getColorId() + " is verlopen!"));
            }
            this.removeColor(color);
            this.setActiveColor(type.defaultColor(), type);
        }
        return color;
    }

    public void addCriminalRecord(String description, UUID officer, Long date) {
        this.policeModule.addCriminalRecord(this.playerModel, description, officer, date);
    }

    public void removeCriminalRecord(CriminalRecordModel criminalRecord) {
        this.policeModule.removeCriminalRecord(this.playerModel, criminalRecord);
    }

    public List<CriminalRecordModel> getCriminalRecords() {
        return this.playerModel.getCriminalRecords();
    }

    public void updatePlaytime() {
        this.playtime += this.resetStart();
        this.playerModel.setPlaytime(this.playtime);
    }

    public void setWageTime(long wageTime) {
        this.wageTime = wageTime;
        this.playerModel.setWageTime(wageTime);
    }

    private long sinceStart() {
        return System.currentTimeMillis() - this.startTime;
    }

    private long resetStart() {
        long since = this.sinceStart();
        this.startTime = System.currentTimeMillis();
        return since;
    }

    public double getCurrencyBalance(String currencyId) {
        CurrencyModel model = this.currencyModule.getCurrencyModels().get(this.playerModel.getUniqueId()).stream().filter(currencyModel -> currencyModel.getName().equalsIgnoreCase(currencyId)).findFirst().orElse(null);
        if (model == null) {
            return 0.0;
        }
        return model.getBalance();
    }

    public void setCurrencyBalance(String currencyId, double amount) {
        CurrencyModel model = this.currencyModule.getCurrencyModels().get(this.playerModel.getUniqueId()).stream().filter(currencyModel -> currencyModel.getName().equalsIgnoreCase(currencyId)).findFirst().orElse(null);
        if (model == null) {
            return;
        }
        model.setBalance(amount);
        StormDatabase.getInstance().saveStormModel(model);
    }

    public void addCurrencyBalance(String currencyId, double amount) {
        CurrencyModel model = this.currencyModule.getCurrencyModels().get(this.playerModel.getUniqueId()).stream().filter(currencyModel -> currencyModel.getName().equalsIgnoreCase(currencyId)).findFirst().orElse(null);
        if (model == null) {
            return;
        }
        model.setBalance(model.getBalance() + amount);
        StormDatabase.getInstance().saveStormModel(model);
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public PlayerModel getPlayerModel() {
        return this.playerModel;
    }

    @Generated
    public boolean isScoreboardVisible() {
        return this.scoreboardVisible;
    }

    @Generated
    public boolean isActionbarVisible() {
        return this.actionbarVisible;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public int getLevel() {
        return this.level;
    }

    @Generated
    public int getCalculatedLevel() {
        return this.calculatedLevel;
    }

    @Generated
    public boolean isStaffchatEnabled() {
        return this.staffchatEnabled;
    }

    @Generated
    public boolean isCommandSpyEnabled() {
        return this.commandSpyEnabled;
    }

    @Generated
    public boolean isChatSpyEnabled() {
        return this.chatSpyEnabled;
    }

    @Generated
    public List<Prefix> getPrefixes() {
        return this.prefixes;
    }

    @Generated
    public List<OwnableColor> getColors() {
        return this.colors;
    }

    @Generated
    public PrefixColor getActivePrefixColor() {
        return this.activePrefixColor;
    }

    @Generated
    public NameColor getActiveNameColor() {
        return this.activeNameColor;
    }

    @Generated
    public ChatColor getActiveChatColor() {
        return this.activeChatColor;
    }

    @Generated
    public LevelColor getActiveLevelColor() {
        return this.activeLevelColor;
    }

    @Generated
    public Fitness getFitness() {
        return this.fitness;
    }

    @Generated
    public void setScoreboardVisible(boolean scoreboardVisible) {
        this.scoreboardVisible = scoreboardVisible;
    }

    @Generated
    public void setActionbarVisible(boolean actionbarVisible) {
        this.actionbarVisible = actionbarVisible;
    }

    @Generated
    public long getPlaytime() {
        return this.playtime;
    }

    @Generated
    public long getWageTime() {
        return this.wageTime;
    }

    @Generated
    public void setCalculatedLevel(int calculatedLevel) {
        this.calculatedLevel = calculatedLevel;
    }

    @Generated
    public void setFitness(Fitness fitness) {
        this.fitness = fitness;
    }

    @Generated
    private PlayerModule getPlayerModule() {
        return this.playerModule;
    }

    @Generated
    private PrefixModule getPrefixModule() {
        return this.prefixModule;
    }

    @Generated
    private ColorModule getColorModule() {
        return this.colorModule;
    }

    @Generated
    private PlacesModule getPlacesModule() {
        return this.placesModule;
    }

    @Generated
    private PoliceModule getPoliceModule() {
        return this.policeModule;
    }

    @Generated
    private CurrencyModule getCurrencyModule() {
        return this.currencyModule;
    }
}

